/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.catalina.loader.WebappClassLoader;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.runtime.tomcat.dev.DevFrameworkBootstrap;
import org.nuxeo.runtime.tomcat.dev.LocalClassLoader;
import org.nuxeo.runtime.tomcat.dev.LocalURLClassLoader;
import org.nuxeo.runtime.tomcat.dev.WebResourcesCacheFlusher;

public class NuxeoDevWebappClassLoader
extends WebappClassLoader
implements MutableClassLoader,
WebResourcesCacheFlusher {
    protected DevFrameworkBootstrap bootstrap;
    protected List<LocalClassLoader> children = new ArrayList<LocalClassLoader>();
    protected volatile LocalClassLoader[] _children;

    public LocalClassLoader createLocalClassLoader(URL ... urls) {
        LocalURLClassLoader cl = new LocalURLClassLoader(urls, (ClassLoader)((Object)this));
        this.addChildren(cl);
        return cl;
    }

    public NuxeoDevWebappClassLoader() {
    }

    public NuxeoDevWebappClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setBootstrap(DevFrameworkBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public DevFrameworkBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public synchronized void addChildren(LocalClassLoader loader) {
        this.children.add(loader);
        this._children = null;
    }

    public synchronized void removeChildren(ClassLoader loader) {
        this.children.remove(loader);
        this._children = null;
    }

    public synchronized void clear() {
        this.children.clear();
        this._children = null;
    }

    @Override
    public synchronized void flushWebResources() {
        this.resourceEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalClassLoader[] getChildren() {
        LocalClassLoader[] cls = this._children;
        if (cls == null) {
            NuxeoDevWebappClassLoader nuxeoDevWebappClassLoader = this;
            synchronized (nuxeoDevWebappClassLoader) {
                this._children = this.children.toArray(new LocalClassLoader[this.children.size()]);
                cls = this._children;
            }
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            NuxeoDevWebappClassLoader nuxeoDevWebappClassLoader = this;
            synchronized (nuxeoDevWebappClassLoader) {
                return super.loadClass(name, resolve);
            }
        }
        catch (ClassNotFoundException e) {
            for (LocalClassLoader cl : this.getChildren()) {
                try {
                    return cl.loadLocalClass(name, resolve);
                }
                catch (ClassNotFoundException ee) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null) {
            return url;
        }
        for (LocalClassLoader cl : this.getChildren()) {
            url = cl.getLocalResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        for (LocalClassLoader cl : this.getChildren()) {
            try {
                is = cl.getLocalResourceAsStream(name);
            }
            catch (IOException e) {
                throw new Error("Cannot read input from " + name, e);
            }
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        CompoundEnumeration<URL> enums = new CompoundEnumeration<URL>();
        enums.add(super.getResources(name));
        for (LocalClassLoader cl : this.getChildren()) {
            enums.add(cl.getLocalResources(name));
        }
        return enums;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public void setParentClassLoader(ClassLoader pcl) {
        super.setParentClassLoader(pcl);
    }

    public ClassLoader getParentClassLoader() {
        return this.parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    protected static class CompoundEnumeration<E>
    implements Enumeration<E> {
        private final List<Enumeration<E>> enums = new ArrayList<Enumeration<E>>();
        private int index = 0;

        public CompoundEnumeration() {
        }

        public CompoundEnumeration(List<Enumeration<E>> enums) {
            this.enums.addAll(enums);
        }

        private boolean next() {
            while (this.index < this.enums.size()) {
                if (this.enums.get(this.index) != null && this.enums.get(this.index).hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums.get(this.index).nextElement();
        }

        public void add(Enumeration<E> e) {
            if (!e.hasMoreElements()) {
                return;
            }
            this.enums.add(e);
        }
    }
}

