/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;

public class DevBundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected final DevBundleType devBundleType;
    protected final String path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DevBundle[] parseDevBundleLines(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            ArrayList<DevBundle> bundles = new ArrayList<DevBundle>();
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    bundles.add(DevBundle.parseDevBundleLine(line));
                }
                line = reader.readLine();
            }
            DevBundle[] devBundleArray = bundles.toArray(new DevBundle[bundles.size()]);
            return devBundleArray;
        }
        finally {
            reader.close();
        }
    }

    public static DevBundle parseDevBundleLine(String line) throws MalformedURLException {
        int index = line.indexOf(58);
        String typename = line.substring(0, index);
        typename = typename.substring(0, 1).toUpperCase() + typename.substring(1);
        String path = line.substring(index + 1);
        return new DevBundle(path, DevBundleType.valueOf(typename));
    }

    public DevBundle(String path, DevBundleType devBundleType) {
        this.path = path;
        this.devBundleType = devBundleType;
    }

    public URL url() throws IOException {
        return new File(this.path).toURI().toURL();
    }

    public File file() {
        return new File(this.path);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.file().getAbsolutePath();
    }
}

