/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Properties;
import org.nuxeo.runtime.api.JndiServiceLocator;
import org.nuxeo.runtime.api.ServiceDescriptor;

public class JBossServiceLocator
extends JndiServiceLocator {
    private String prefix;
    private String suffix;

    public void initialize(Properties properties) throws Exception {
        super.initialize(properties);
        this.prefix = properties.getProperty("prefix", "nuxeo/");
        this.suffix = properties.getProperty("suffix", "/remote");
    }

    public Object lookup(ServiceDescriptor sd) throws Exception {
        String locator = sd.getLocator();
        if (locator == null) {
            locator = this.prefix + sd.getServiceClass().getSimpleName() + this.suffix;
            sd.setLocator(locator);
        } else if (locator.startsWith("%")) {
            locator = this.prefix + locator.substring(1) + this.suffix;
            sd.setLocator(locator);
        }
        return this.lookup(locator);
    }
}

