/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Properties;
import javax.naming.InitialContext;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceLocator;

public class JndiServiceLocator
implements ServiceLocator {
    protected InitialContext context;

    public void initialize(Properties properties) throws Exception {
        this.context = new InitialContext(properties);
    }

    public void dispose() {
        this.context = null;
    }

    public Object lookup(ServiceDescriptor sd) throws Exception {
        String locator = sd.getLocator();
        if (locator == null) {
            locator = this.createLocator(sd);
            sd.setLocator(locator);
        }
        return this.lookup(locator);
    }

    public Object lookup(String serviceId) throws Exception {
        return this.context.lookup(serviceId);
    }

    public InitialContext getContext() {
        return this.context;
    }

    protected String createLocator(ServiceDescriptor sd) {
        return sd.getServiceClass().getName();
    }
}

