/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.BindingException;
import org.nuxeo.runtime.api.Server;
import org.nuxeo.runtime.api.ServiceAdapter;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="service", order={"serviceClass", "name"})
public class ServiceDescriptor {
    @XNode(value="@name")
    private String name;
    @XNode(value="@class")
    private Class<?> serviceClass;
    @XNode(value="adapter")
    private Class<ServiceAdapter> adapterClass;
    private ServiceAdapter adapter;
    @XNode(value="locator")
    private String locator;
    private ServiceGroup group;

    public ServiceDescriptor() {
    }

    public ServiceDescriptor(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public ServiceDescriptor(Class<?> serviceClass, String group) {
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
    }

    @XNode(value="@group")
    public void setGroup(String group) {
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
    }

    public ServiceGroup getGroup() {
        return this.group;
    }

    public Server getServer() throws BindingException {
        return this.getGroup().getServer();
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public String getInstanceName() {
        return this.name != null ? this.serviceClass.getName() + '#' + this.name : this.serviceClass.getName();
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public ServiceAdapter getAdapter() throws Exception {
        if (this.adapterClass == null) {
            return null;
        }
        if (this.adapter == null) {
            this.adapter = this.adapterClass.newInstance();
        }
        return this.adapter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ServiceDescriptor) {
            ServiceDescriptor sd = (ServiceDescriptor)obj;
            if (this.serviceClass != sd.serviceClass) {
                return false;
            }
            if (this.name != null ? !this.name.equals(sd.name) : this.name != sd.name) {
                return false;
            }
            return this.group.getName().equals(sd.group.getName());
        }
        return false;
    }
}

