/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.Server;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceLocator;
import org.nuxeo.runtime.api.ServiceLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceManager {
    private static final Log log = LogFactory.getLog(ServiceManager.class);
    private static final ServiceManager instance = new ServiceManager();
    protected final Map<String, ServiceDescriptor> services = new HashMap<String, ServiceDescriptor>();
    protected final List<Server> servers = new Vector<Server>();
    protected final Map<String, ServiceGroup> groups = new HashMap<String, ServiceGroup>();

    private ServiceManager() {
    }

    public static ServiceManager getInstance() {
        return instance;
    }

    public ServiceDescriptor[] getServiceDescriptors() {
        return this.services.values().toArray(new ServiceDescriptor[this.services.size()]);
    }

    public ServiceDescriptor getServiceDescriptor(Class<?> serviceClass) {
        return this.getServiceDescriptor(serviceClass.getName());
    }

    public ServiceDescriptor getServiceDescriptor(String serviceClass) {
        return this.services.get(serviceClass);
    }

    public ServiceDescriptor getServiceDescriptor(Class<?> serviceClass, String name) {
        return this.getServiceDescriptor(serviceClass.getName(), name);
    }

    public ServiceDescriptor getServiceDescriptor(String serviceClass, String name) {
        return this.services.get(serviceClass + '#' + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceDescriptor sd) {
        String key = sd.getInstanceName();
        Map<String, ServiceDescriptor> map = this.services;
        synchronized (map) {
            if (this.services.containsKey(key)) {
                log.warn((Object)("Service " + key + " already registered!"));
            }
            this.services.put(key, sd);
            sd.getGroup().addService(sd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(ServiceDescriptor sd) {
        String key = sd.getInstanceName();
        Map<String, ServiceDescriptor> map = this.services;
        synchronized (map) {
            sd = this.services.remove(key);
            sd.getGroup().removeService(sd);
        }
    }

    public <T> T getService(Class<T> serviceClass) throws Exception {
        ServiceDescriptor sd = this.services.get(serviceClass.getName());
        if (sd == null) {
            return Framework.getRuntime().getService(serviceClass);
        }
        return (T)sd.getGroup().getServer().lookup(sd);
    }

    public <T> T getService(Class<T> serviceClass, String name) throws Exception {
        ServiceDescriptor sd = this.services.get(serviceClass.getName() + '#' + name);
        if (sd == null) {
            return Framework.getRuntime().getService(serviceClass);
        }
        return (T)sd.getGroup().getServer().lookup(sd);
    }

    public Object getService(String serviceUri) throws Exception {
        URI uri = new URI(serviceUri);
        ServiceLocatorFactory factory = ServiceLocatorFactory.getFactory(uri.getScheme());
        if (factory != null) {
            ServiceLocator locator = factory.createLocator(uri);
            return locator.lookup(uri.getPath().substring(1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceGroup getOrCreateGroup(String name) {
        if (name == null || name.equals("")) {
            name = "*";
        }
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            ServiceGroup group = this.groups.get(name);
            if (group == null) {
                group = new ServiceGroup(name);
                this.groups.put(name, group);
            }
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceGroup getGroup(String name) {
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            return this.groups.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            this.groups.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String name) {
        if (name == null || name.equals("")) {
            name = "*";
        }
        ServiceGroup group = new ServiceGroup(name);
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            this.groups.put(name, group);
        }
    }

    public ServiceGroup getRootGroup() {
        return this.getOrCreateGroup("*");
    }

    public void registerServer(Server server) {
        this.servers.add(server);
    }

    public void unregisterServer(Server server) {
        this.servers.remove(server);
        server.dispose();
    }

    public void unregisterServers() {
        for (Server server : this.servers) {
            server.dispose();
        }
        this.servers.clear();
    }

    public Server[] getServers() {
        return this.servers.toArray(new Server[this.servers.size()]);
    }
}

