/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.login.DefaultCallbackHandler;
import org.nuxeo.runtime.api.login.LoginModuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="domain")
public class SecurityDomain {
    @XNode(value="@name")
    private String name;
    private AppConfigurationEntry[] entries;

    public SecurityDomain() {
    }

    public SecurityDomain(String name, AppConfigurationEntry[] entries) {
        this.name = name;
        this.entries = entries;
    }

    public String getName() {
        return this.name;
    }

    public AppConfigurationEntry[] getAppConfigurationEntries() {
        return this.entries;
    }

    @XNodeList(value="login-module", type=ArrayList.class, componentType=LoginModuleDescriptor.class)
    public void setEntries(List<LoginModuleDescriptor> descriptors) {
        this.entries = new AppConfigurationEntry[descriptors.size()];
        int i = 0;
        for (LoginModuleDescriptor descriptor : descriptors) {
            AppConfigurationEntry.LoginModuleControlFlag flag = null;
            if (descriptor.flag == null) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if ("optional".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if ("sufficient".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if ("required".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if ("requisite".equals(descriptor.flag)) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            this.entries[i++] = new AppConfigurationEntry(descriptor.code, flag, descriptor.options);
        }
    }

    public LoginContext login(Subject subject) throws LoginException {
        LoginContext ctx = new LoginContext(this.name, subject);
        ctx.login();
        return ctx;
    }

    public LoginContext login(CallbackHandler handler) throws LoginException {
        LoginContext ctx = new LoginContext(this.name, handler);
        ctx.login();
        return ctx;
    }

    public LoginContext login(Subject subject, CallbackHandler handler) throws LoginException {
        LoginContext ctx = new LoginContext(this.name, subject, handler);
        ctx.login();
        return ctx;
    }

    public LoginContext login(String username, Object credentials) throws LoginException {
        DefaultCallbackHandler handler = new DefaultCallbackHandler(username, credentials);
        LoginContext ctx = new LoginContext(this.name, handler);
        ctx.login();
        return ctx;
    }
}

