/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentDescriptorReader;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

public class DefaultRuntimeContext
implements RuntimeContext {
    private static final Log log = LogFactory.getLog(RuntimeContext.class);
    protected RuntimeService runtime;
    protected final ComponentDescriptorReader reader;
    protected final Map<String, ComponentName> deployedFiles;

    public DefaultRuntimeContext() {
        this(Framework.getRuntime());
    }

    public DefaultRuntimeContext(RuntimeService runtime) {
        this.runtime = runtime;
        this.reader = new ComponentDescriptorReader();
        this.deployedFiles = new Hashtable<String, ComponentName>();
    }

    public void setRuntime(RuntimeService runtime) {
        this.runtime = runtime;
    }

    public RuntimeService getRuntime() {
        return this.runtime;
    }

    public URL getResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    public URL getLocalResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    public void deploy(URL url) throws Exception {
        if (this.deployedFiles.containsKey(url.toString())) {
            return;
        }
        log.debug((Object)("Deploying bundle from url " + url));
        RegistrationInfoImpl ri = this.createRegistrationInfo(url);
        ri.context = this;
        this.runtime.getComponentManager().register(ri);
        this.deployedFiles.put(url.toString(), ri.getName());
    }

    public void undeploy(URL url) throws Exception {
        ComponentName name = this.deployedFiles.remove(url.toString());
        if (name != null) {
            this.runtime.getComponentManager().unregister(name);
        }
    }

    public boolean isDeployed(URL url) {
        return this.deployedFiles.containsKey(url.toString());
    }

    public void deploy(String location) throws Exception {
        URL url = this.getLocalResource(location);
        if (url != null) {
            this.deploy(url);
        } else {
            log.warn((Object)("No local resources was found with this name: " + location));
        }
    }

    public void undeploy(String location) throws Exception {
        URL url = this.getLocalResource(location);
        if (url != null) {
            this.undeploy(url);
        } else {
            log.warn((Object)("No local resources was found with this name: " + location));
        }
    }

    public boolean isDeployed(String location) {
        URL url = this.getLocalResource(location);
        if (url != null) {
            return this.isDeployed(url);
        }
        log.warn((Object)("No local resources was found with this name: " + location));
        return false;
    }

    public void destroy() {
        Iterator<ComponentName> it = this.deployedFiles.values().iterator();
        ComponentManager mgr = this.runtime.getComponentManager();
        while (it.hasNext()) {
            ComponentName name = it.next();
            it.remove();
            mgr.unregister(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegistrationInfoImpl createRegistrationInfo(URL url) throws Exception {
        InputStream in = url.openStream();
        try {
            RegistrationInfoImpl registrationInfoImpl = this.reader.read(this, in);
            return registrationInfoImpl;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

