/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.Property;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;
import org.nuxeo.runtime.model.impl.ExtensionImpl;
import org.nuxeo.runtime.remoting.RemoteComponent;
import org.nuxeo.runtime.remoting.RemoteComponentInstance;
import org.nuxeo.runtime.remoting.RemoteContext;
import org.nuxeo.runtime.remoting.RemoteEvent;
import org.nuxeo.runtime.remoting.Server;
import org.nuxeo.runtime.remoting.ServerDescriptor;
import org.nuxeo.runtime.remoting.ServerImpl;
import org.nuxeo.runtime.remoting.ServerRegistry;
import org.nuxeo.runtime.remoting.net.EventHandler;
import org.nuxeo.runtime.remoting.net.NetworkNode;
import org.nuxeo.runtime.remoting.net.NetworkNodeFactory;
import org.nuxeo.runtime.remoting.net.NodeInfo;
import org.nuxeo.runtime.remoting.net.impl.NetworkNodeFactoryImpl;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;
import org.nuxeo.runtime.remoting.transporter.TransporterServer;

public class RemotingService
extends DefaultComponent
implements ComponentListener,
EventHandler {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.remoting.RemotingService");
    private static final Log log = LogFactory.getLog(RemotingService.class);
    private ServerRegistry servers;
    private TransporterServer transporterServer;
    private Server server;
    private NetworkNode node;
    private RuntimeService runtime;

    public static Server connect(String host, int port) throws Exception {
        return (Server)TransporterClient.createTransporterClient(new InvokerLocator("socket://" + host + ":" + port + "/nxruntime"), Server.class);
    }

    public static void disconnect(Server server) {
        TransporterClient.destroyTransporterClient(server);
    }

    public void activate(ComponentContext context) throws Exception {
        int p;
        this.runtime = context.getRuntimeContext().getRuntime();
        Property host = context.getProperty("server-host");
        Property port = context.getProperty("server-port");
        String hdef = System.getProperty("nxruntime-host", "127.0.0.1");
        String h = host != null ? host.getString() : hdef;
        Integer pdef = Integer.getInteger("nxruntime-port");
        int n = p = port != null ? port.getInteger() : 62474;
        if (pdef != null) {
            p = pdef;
        }
        InvokerLocator serverLocator = new InvokerLocator("socket", h, p, "nxruntime", null);
        this.server = new ServerImpl(this, context.getRuntimeContext().getRuntime());
        this.transporterServer = TransporterServer.createTransporterServer(serverLocator, (Object)this.server, Server.class.getName());
        boolean isNetworkingEnabled = (Boolean)context.getPropertyValue("net-enabled", Boolean.FALSE);
        if (isNetworkingEnabled) {
            log.info((Object)"Starting networking");
            Framework.getRuntime().getComponentManager().addComponentListener(this);
            String netFactory = null;
            Property netFactoryProp = context.getProperty("net-factory");
            if (netFactoryProp != null) {
                netFactory = netFactoryProp.getString();
            }
            NetworkNodeFactory factory = netFactory != null ? (NetworkNodeFactory)context.getRuntimeContext().loadClass(netFactory).newInstance() : new NetworkNodeFactoryImpl();
            NodeInfo info = new NodeInfo(serverLocator.getLocatorURI());
            info.name = (String)context.getPropertyValue("server-name");
            info.description = (String)context.getPropertyValue("server-description", this.runtime.getDescription());
            this.node = factory.createNode(this, info);
            Property groupProp = context.getProperty("net-group");
            String group = null;
            if (groupProp != null) {
                group = groupProp.getString();
            }
            this.servers = new ServerRegistry(this.node);
            this.node.setEventHandler(this);
            this.node.connect(group);
        } else {
            log.info((Object)"Networking is disabled.");
        }
    }

    public TransporterServer getTransporterServer() {
        return this.transporterServer;
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.servers != null) {
            this.servers.clear();
        }
        Framework.getRuntime().getComponentManager().removeComponentListener(this);
        if (this.node != null) {
            this.node.disconnect();
        }
        if (this.transporterServer != null) {
            this.transporterServer.stop();
            this.transporterServer = null;
        }
    }

    public Server getServer() {
        return this.server;
    }

    public ServerDescriptor[] getServers() {
        return this.servers.getServers();
    }

    public ServerDescriptor getServer(String uri) {
        return this.servers.get(uri);
    }

    public void handleEvent(ComponentEvent event) {
        switch (event.id) {
            case 4: {
                RemoteEvent revent = new RemoteEvent(1, null, (Serializable)new ComponentName[]{event.registrationInfo.getName()});
                this.sendRemoteEvent(revent);
                break;
            }
            case 5: {
                RemoteEvent revent = new RemoteEvent(2, null, (Serializable)new ComponentName[]{event.registrationInfo.getName()});
                this.sendRemoteEvent(revent);
                break;
            }
            case 11: {
                ExtensionImpl extension = (ExtensionImpl)event.data;
                ComponentName target = extension.getTargetComponent();
                ComponentName contributor = extension.getComponent().getName();
                RemoteEvent revent = new RemoteEvent(3, contributor, (Serializable)((Object)extension.toXML()));
                for (ServerDescriptor sd : this.getServers()) {
                    boolean isNew;
                    if (!sd.hasComponent(target) || !(isNew = sd.addExtension(extension.getId()))) continue;
                    try {
                        log.info((Object)("Sending extension " + extension.getId() + " to " + sd.getURI()));
                        this.node.sendTo(sd.getURI(), revent);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to send extension " + extension.getId() + " to " + sd.getURI()), (Throwable)e);
                    }
                }
                break;
            }
            case 10: {
                ExtensionImpl extension = (ExtensionImpl)event.data;
                ComponentName target = extension.getTargetComponent();
                ComponentName contributor = extension.getComponent().getName();
                RemoteEvent revent = new RemoteEvent(4, contributor, (Serializable)((Object)extension.toXML()));
                for (ServerDescriptor sd : this.getServers()) {
                    if (!sd.hasComponent(target) || !sd.removeExtension(extension.getId())) continue;
                    try {
                        log.info((Object)("Sending extension " + extension.getId() + " to " + sd.getURI()));
                        this.node.sendTo(sd.getURI(), revent);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to send extension " + extension.getId() + " to " + sd.getURI()), (Throwable)e);
                    }
                }
                break;
            }
        }
    }

    private void sendRemoteEvent(RemoteEvent event) {
        try {
            this.node.send(event);
        }
        catch (Exception e) {
            log.error((Object)("Failed to broadcast event " + event), (Throwable)e);
        }
    }

    public ComponentName[] getComponents() {
        Collection<RegistrationInfo> regs = Framework.getRuntime().getComponentManager().getRegistrations();
        ArrayList<ComponentName> comps = new ArrayList<ComponentName>();
        for (RegistrationInfo ri : regs) {
            comps.add(ri.getName());
        }
        return comps.toArray(new ComponentName[comps.size()]);
    }

    public void peerConnected(NodeInfo info) {
        log.info((Object)("Peer connected " + info + ". Sending our configuration"));
        try {
            ComponentName[] components = this.getComponents();
            RemoteEvent revent = new RemoteEvent(1, null, (Serializable)components);
            try {
                this.node.sendTo(info.uri, revent);
            }
            catch (Exception e) {
                log.error((Object)("Failed to send COMPONENTS_ADDED event to " + info), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to add peer " + info), (Throwable)e);
        }
    }

    public void peerRemoved(String uri) {
        log.info((Object)("Removing peer server: " + uri));
        this.servers.remove(uri);
    }

    public void handleEvent(String senderUri, Serializable object) {
        if (!(object instanceof RemoteEvent)) {
            return;
        }
        RemoteEvent event = (RemoteEvent)object;
        switch (event.id) {
            case 1: {
                this.handleComponentsAdded(senderUri, event);
                break;
            }
            case 2: {
                this.handleComponentsRemoved(senderUri, event);
                break;
            }
            case 3: {
                try {
                    this.handleExtensionAdded(senderUri, event);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to handle EXTENSION_ADDED event", (Throwable)e);
                }
                break;
            }
            case 4: {
                try {
                    this.handleExtensionRemoved(senderUri, event);
                    break;
                }
                catch (Exception e) {
                    log.error((Object)"Failed to handle EXTENSION_REMOVED event", (Throwable)e);
                }
            }
        }
    }

    protected void sendPendingExtensions(ServerDescriptor sd) throws Exception {
        for (ComponentName target : sd.getComponents()) {
            this.sendPendingExtensions(sd, target);
        }
    }

    protected void sendPendingExtensions(ServerDescriptor sd, ComponentName target) throws Exception {
        ComponentManagerImpl mgr = (ComponentManagerImpl)this.runtime.getComponentManager();
        Collection<Extension> extensions = mgr.getPendingExtensions(target);
        if (extensions != null) {
            RemoteEvent event = new RemoteEvent(3, null, null);
            for (Extension extension : extensions) {
                boolean isNew = sd.addExtension(extension.getId());
                if (!isNew) continue;
                event.component = extension.getComponent().getName();
                event.data = extension.toXML();
                this.node.sendTo(sd.getURI(), event);
            }
        }
    }

    protected void handleComponentsAdded(String senderUri, RemoteEvent event) {
        ServerDescriptor sd = this.servers.get(senderUri);
        if (sd == null) {
            log.error((Object)("COMPONENTS_ADDED was received from an unknown server: " + senderUri + ". Ignoring it"));
            return;
        }
        Object[] comps = (ComponentName[])event.data;
        log.info((Object)("COMPONENTS_ADDED event received from " + senderUri + " : " + Arrays.toString(comps)));
        for (Object name : comps) {
            try {
                if (sd.hasComponent((ComponentName)name)) continue;
                sd.addComponent((ComponentName)name);
                this.sendPendingExtensions(sd, (ComponentName)name);
            }
            catch (Exception e) {
                log.error((Object)("Failed to send EXTENSIONS_ADDED to r: " + senderUri));
            }
        }
    }

    protected void handleComponentsRemoved(String senderUri, RemoteEvent event) {
        ServerDescriptor sd = this.servers.get(senderUri);
        if (sd == null) {
            log.error((Object)("COMPONENTS_REMOVED was received from an unknown server: " + senderUri + ". Ignoring it"));
            return;
        }
        Object[] comps = (ComponentName[])event.data;
        log.info((Object)("COMPONENTS_REMOVED event received from " + senderUri + " : " + Arrays.toString(comps)));
        ComponentManagerImpl mgr = (ComponentManagerImpl)this.runtime.getComponentManager();
        for (Object name : comps) {
            RemoteComponent rco = sd.removeComponent((ComponentName)name);
            if (rco == null) continue;
            for (Extension xt : rco.getExtensions()) {
                try {
                    log.info((Object)("Unregistering remote extension: " + xt.getId()));
                    mgr.unregisterExtension(xt);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to unregister remote extension", (Throwable)e);
                }
            }
        }
    }

    protected void handleExtensionAdded(String senderUri, RemoteEvent event) throws Exception {
        ServerDescriptor sd = this.servers.get(senderUri);
        if (sd == null) {
            log.error((Object)("EXTENSION_ADDED was received from an unknown server: " + senderUri + ". Ignoring it"));
            return;
        }
        log.info((Object)("EXTENSION_ADDED event received from " + senderUri + " : " + event.data));
        ComponentManagerImpl mgr = (ComponentManagerImpl)this.runtime.getComponentManager();
        RemoteContext ctx = new RemoteContext(sd, event.component, null);
        ExtensionImpl extension = ExtensionImpl.fromXML(ctx, (String)((Object)event.data));
        extension.setComponent(new RemoteComponentInstance(event.component, ctx));
        try {
            mgr.registerExtension(extension);
            ComponentName target = extension.getTargetComponent();
            RemoteComponent rco = sd.getComponent(target);
            if (rco == null) {
                rco = sd.addComponent(target);
            }
            rco.addExtension(extension);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void handleExtensionRemoved(String senderUri, RemoteEvent event) throws Exception {
        ServerDescriptor sd = this.servers.get(senderUri);
        if (sd == null) {
            log.error((Object)("EXTENSION_REMOVED was received from an unknown server: " + senderUri + ". Ignoring it"));
            return;
        }
        log.info((Object)("EXTENSION_REMOVED event received from " + senderUri + " : " + event.data));
        ComponentManagerImpl mgr = (ComponentManagerImpl)this.runtime.getComponentManager();
        RemoteContext ctx = new RemoteContext(sd, event.component, null);
        ExtensionImpl extension = ExtensionImpl.fromXML(ctx, (String)((Object)event.data));
        extension.setComponent(new RemoteComponentInstance(event.component, ctx));
        try {
            mgr.unregisterExtension(extension);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

