/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.loading.ClassUtil;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerImpl
implements Server {
    private static final Log log = LogFactory.getLog(ServerImpl.class);
    private final RuntimeService runtime;
    private final RemotingService remoting;

    public ServerImpl(RemotingService service, RuntimeService runtime) {
        this.remoting = service;
        this.runtime = runtime;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String[] getServiceBindings() {
        ServiceManager sm = Framework.getLocalService(ServiceManager.class);
        ServiceDescriptor[] services = sm.getServiceDescriptors();
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceDescriptor sd : services) {
            result.add(sd.getGroup().getName());
            result.add(sd.getServiceClass().getName());
            result.add(sd.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Map<String, Properties> getServiceLocators() throws Exception {
        ServiceManager sm = Framework.getLocalService(ServiceManager.class);
        org.nuxeo.runtime.api.Server[] servers = sm.getServers();
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        for (org.nuxeo.runtime.api.Server server : servers) {
            String key = server.getServiceLocator().getClass().getName();
            Properties value = server.getProperties();
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        Properties rtProps = Framework.getRuntime().getProperties();
        for (Map.Entry<Object, Object> entry : rtProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = Framework.expandVars(entry.getValue().toString());
            props.put(key, value);
        }
        return props;
    }

    @Override
    public ComponentName[] getComponents() {
        Collection<RegistrationInfo> regs = Framework.getRuntime().getComponentManager().getRegistrations();
        ArrayList<ComponentName> comps = new ArrayList<ComponentName>();
        for (RegistrationInfo ri : regs) {
            comps.add(ri.getName());
        }
        return comps.toArray(new ComponentName[comps.size()]);
    }

    @Override
    public boolean hasComponent(ComponentName name) {
        return false;
    }

    @Override
    public Collection<ComponentInstance> getActiveComponents() {
        return null;
    }

    @Override
    public ComponentInstance getComponent(String name) {
        return null;
    }

    @Override
    public ComponentInstance getComponent(ComponentName name) {
        return null;
    }

    @Override
    public String getDescription() {
        return this.runtime.getDescription();
    }

    @Override
    public Collection<RegistrationInfo> getRegistrations() {
        return this.runtime.getComponentManager().getRegistrations();
    }

    @Override
    public String getServerAddress() {
        return null;
    }

    public void contributeExtension(Extension extension, String xmlContent) throws Exception {
    }

    @Override
    public byte[] getLocalResource(ComponentName component, String name) {
        return this.getResource(component, name);
    }

    @Override
    public byte[] getResource(ComponentName component, String name) {
        log.info((Object)("Loading resource: " + name + " using " + component + " context"));
        ComponentInstance ci = Framework.getRuntime().getComponentInstance(component);
        if (ci == null) {
            return null;
        }
        URL url = ci.getContext().getResource(name);
        if (url != null) {
            try {
                return FileUtils.readBytes((URL)url);
            }
            catch (IOException e) {
                log.error((Object)("Failed to load resource: " + name), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public byte[] getClass(ComponentName component, String name) {
        log.info((Object)("Loading class: " + name + " using " + component + " context"));
        ComponentInstance ci = Framework.getRuntime().getComponentInstance(component);
        if (ci == null) {
            return null;
        }
        String resourceName = this.getClassResource(name);
        URL classUrl = ci.getContext().getResource(resourceName);
        if (classUrl != null) {
            try {
                return FileUtils.readBytes((URL)classUrl);
            }
            catch (IOException e) {
                log.error((Object)("Failed to load class " + name), (Throwable)e);
            }
        }
        return null;
    }

    private String getClassResource(String className) {
        String cn = ClassUtil.isArrayClass((String)className) ? ClassUtil.getArrayClassPart((String)className).replace('.', '/') + ".class" : className.replace('.', '/') + ".class";
        return cn;
    }
}

