/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.runtime.services.streaming.DownloadInfo;
import org.nuxeo.runtime.services.streaming.StreamManagerClient;

public class RemoteInputStream
extends InputStream {
    private final StreamManagerClient streamMgr;
    private final String uri;
    private long sid = 0L;
    private boolean eof = false;
    private byte[] buffer = new byte[4096];
    private int start = 0;
    private int end = 0;
    private int preferredSize = 65536;

    public RemoteInputStream(StreamManagerClient streamMgr, String uri) {
        this.streamMgr = streamMgr;
        this.uri = uri;
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("method not imple,mented -> use read(byte[]) instead");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        int available = this.end - this.start;
        if (available > 0) {
            int needBytes = len - available;
            if (needBytes > 0) {
                System.arraycopy(this.buffer, this.start, b, off, available);
                int ava = this.fillBytes(needBytes);
                if (this.eof) {
                    return available;
                }
                System.arraycopy(this.buffer, this.start, b, off + available, ava);
                this.start += ava;
                return available + ava;
            }
            if (this.buffer == null || this.buffer.length == 0) {
                this.sid = 0L;
                this.fillBytes(len);
            }
            System.arraycopy(this.buffer, this.start, b, off, len);
            this.start += len;
            return len;
        }
        int ava = this.fillBytes(len);
        if (this.eof) {
            return -1;
        }
        System.arraycopy(this.buffer, this.start, b, off, ava);
        this.start += ava;
        return ava;
    }

    protected int fillBytes(int count) throws IOException {
        if (this.eof) {
            int available = this.end - this.start;
            if (available < 1) {
                return -1;
            }
            return count < available ? count : available;
        }
        int initialCount = count;
        if (this.sid == 0L) {
            DownloadInfo di = this.streamMgr.getServer().createDownloadSession(this.uri);
            this.preferredSize = this.streamMgr.getBufferSize(di.preferredSize);
            this.sid = di.sid;
        }
        if (count < this.preferredSize) {
            count = this.preferredSize;
        }
        this.buffer = this.streamMgr.getServer().downloadBytes(this.sid, count);
        this.start = 0;
        if (this.buffer == null) {
            this.eof = true;
            return -1;
        }
        this.end = this.buffer.length;
        return this.buffer.length > initialCount ? initialCount : this.buffer.length;
    }

    public void close() throws IOException {
        if (this.sid != 0L) {
            this.streamMgr.getServer().closeDownloadSession(this.sid);
            this.sid = 0L;
            this.eof = false;
        }
    }
}

