/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.File;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamManagerClient;
import org.nuxeo.runtime.services.streaming.StreamManagerServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.streaming");
    protected StreamManager manager;

    @Override
    public void activate(ComponentContext context) throws Exception {
        int minBufSize = (Integer)context.getPropertyValue("minBufferSize", 8192);
        int maxBufSize = (Integer)context.getPropertyValue("maxBufferSize", 0x800000);
        boolean isServer = (Boolean)context.getPropertyValue("isServer", false);
        String serverLocator = (String)context.getPropertyValue("serverLocator", "socket://127.0.0.1:3233");
        if (serverLocator == null) {
            throw new IllegalArgumentException("serverLocator must not be null when defining a StreamingService");
        }
        if (isServer) {
            File tmpDir = new File(Framework.getRuntime().getHome(), "tmp/uploads");
            this.manager = new StreamManagerServer(serverLocator, tmpDir);
        } else {
            this.manager = new StreamManagerClient(serverLocator, minBufSize, maxBufSize);
        }
        this.manager.start();
    }

    @Override
    public void deactivate(ComponentContext context) throws Exception {
        this.manager.stop();
        this.manager = null;
        super.deactivate(context);
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public StreamManager getStreamManager() {
        return this.manager;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (StreamManager.class.isAssignableFrom(adapter)) {
            return (T)this.manager;
        }
        return null;
    }
}

