/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Properties;
import javax.naming.InitialContext;
import org.nuxeo.runtime.api.JndiServiceLocator;
import org.nuxeo.runtime.api.ServiceDescriptor;

public class JBossServiceLocator
extends JndiServiceLocator {
    private String prefix;
    private String suffix;

    public void initialize(String host, int port, Properties properties) throws Exception {
        if (properties != null) {
            this.prefix = properties.getProperty("prefix", "nuxeo/");
            this.suffix = properties.getProperty("suffix", "/remote");
        } else {
            properties = new Properties();
            properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            properties.put("java.naming.provider.url", "jnp://localhost:1099");
            properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        }
        if (host != null) {
            String uri = "jnp://" + host + (port == 0 ? 1099 : port);
            properties.put("java.naming.provider.url", uri);
        }
        this.context = new InitialContext(properties);
    }

    public Object lookup(ServiceDescriptor sd) throws Exception {
        String locator = sd.getLocator();
        if (locator == null) {
            locator = this.prefix + sd.getServiceClassSimpleName() + this.suffix;
            sd.setLocator(locator);
        } else if (locator.startsWith("%")) {
            locator = this.prefix + locator.substring(1) + this.suffix;
            sd.setLocator(locator);
        }
        return this.lookup(locator);
    }
}

