/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.runtime.api.login.DefaultCallbackHandler;
import org.nuxeo.runtime.api.login.LoginConfiguration;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.api.login.SystemLoginPermission;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginComponent
extends DefaultComponent
implements LoginService {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.LoginComponent");
    public static final String SYSTEM_LOGIN = "nuxeo-system-login";
    public static final String CLIENT_LOGIN = "nuxeo-client-login";
    public static final String SYSTEM_USERNAME = "system";
    private static final SystemID SYSTEM_ID = new SystemID();
    private LoginConfiguration config;
    private final Map<String, SecurityDomain> domains = new Hashtable<String, SecurityDomain>();
    private SecurityDomain systemLogin;
    private SecurityDomain clientLogin;

    @Override
    public void activate(ComponentContext context) throws Exception {
        Configuration parentConfig = null;
        try {
            parentConfig = Configuration.getConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.config = new LoginConfiguration(this, parentConfig);
        Configuration.setConfiguration(this.config);
    }

    @Override
    public void deactivate(ComponentContext context) throws Exception {
        Configuration.setConfiguration(this.config.getParent());
        this.config = null;
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("domains")) {
            SecurityDomain domain = (SecurityDomain)contribution;
            this.addSecurityDomain(domain);
        }
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("domains")) {
            SecurityDomain domain = (SecurityDomain)contribution;
            this.removeSecurityDomain(domain.getName());
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        SecurityDomain domain = this.domains.get(name);
        if (domain != null) {
            return domain.getAppConfigurationEntries();
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (LoginService.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public SecurityDomain getSecurityDomain(String name) {
        return this.domains.get(name);
    }

    @Override
    public void addSecurityDomain(SecurityDomain domain) {
        this.domains.put(domain.getName(), domain);
        if (SYSTEM_LOGIN.equals(domain.getName())) {
            this.systemLogin = domain;
        } else if (CLIENT_LOGIN.equals(domain.getName())) {
            this.clientLogin = domain;
        }
    }

    @Override
    public void removeSecurityDomain(String name) {
        this.domains.remove(name);
        if (SYSTEM_LOGIN.equals(name)) {
            this.systemLogin = null;
        } else if (CLIENT_LOGIN.equals(name)) {
            this.clientLogin = null;
        }
    }

    @Override
    public SecurityDomain[] getSecurityDomains() {
        return this.domains.values().toArray(new SecurityDomain[this.domains.size()]);
    }

    @Override
    public void removeSecurityDomains() {
        this.domains.clear();
        this.systemLogin = null;
        this.clientLogin = null;
    }

    private LoginContext systemLogin() throws LoginException {
        if (this.systemLogin != null) {
            HashSet<SystemID> principals = new HashSet<SystemID>();
            principals.add(SYSTEM_ID);
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            return this.systemLogin.login(subject, new DefaultCallbackHandler(SYSTEM_USERNAME, SYSTEM_ID));
        }
        return null;
    }

    @Override
    public LoginContext login() throws LoginException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<LoginContext>(){

                @Override
                public LoginContext run() throws LoginException {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new SystemLoginPermission());
                    }
                    return LoginComponent.this.systemLogin();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (LoginException)e.getException();
        }
    }

    @Override
    public LoginContext login(String username, Object credentials) throws LoginException {
        if (this.clientLogin != null) {
            return this.clientLogin.login(username, credentials);
        }
        return null;
    }

    @Override
    public LoginContext login(CallbackHandler cbHandler) throws LoginException {
        if (this.clientLogin != null) {
            return this.clientLogin.login(cbHandler);
        }
        return null;
    }

    @Override
    public boolean isSystemId(Principal principal) {
        return SYSTEM_ID == principal;
    }

    public static boolean isSystemLogin(Principal principal) {
        return SYSTEM_ID == principal;
    }

    private static class SystemID
    implements Principal,
    Externalizable {
        public String getName() {
            return LoginComponent.SYSTEM_USERNAME;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        protected Object readResolve() {
            return SYSTEM_ID;
        }
    }
}

