/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Map;
import java.util.Properties;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.RuntimeServiceLocator;
import org.nuxeo.runtime.api.ServiceAdapter;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceLocator;
import org.nuxeo.runtime.api.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="server")
public class ServiceHost {
    public static final ServiceHost LOCAL_SERVER = new ServiceHost(RuntimeServiceLocator.class);
    @XNode(value="@class")
    private Class<? extends ServiceLocator> serviceLocatorClass;
    @XNode(value="@host")
    private String host;
    @XNode(value="@port")
    private int port;
    private Properties properties;
    private ServiceGroup[] groups;
    private ServiceLocator serviceLocator;

    public ServiceHost() {
    }

    public ServiceHost(Class<? extends ServiceLocator> serverClass) {
        this.serviceLocatorClass = serverClass;
    }

    public ServiceHost(Class<? extends ServiceLocator> serverClass, String[] groups) {
        this(serverClass);
        this.setGroups(groups);
    }

    protected ServiceLocator createServiceLocator() throws Exception {
        ServiceLocator serviceLocator = this.serviceLocatorClass.newInstance();
        serviceLocator.initialize(this.host, this.port, this.properties);
        return serviceLocator;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @XNodeMap(value="property", key="@name", componentType=String.class, type=Properties.class, trim=true)
    public void setProperties(Properties properties) {
        this.properties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value.getClass() == String.class) {
                this.properties.put(entry.getKey().toString(), Framework.expandVars(value.toString().trim()));
                continue;
            }
            this.properties.put(entry.getKey(), value);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defValue) {
        return this.properties.getProperty(key, defValue);
    }

    @XNodeList(value="group", componentType=String.class, type=String[].class, trim=true)
    public void setGroups(String[] groups) {
        this.groups = new ServiceGroup[groups.length];
        ServiceManager mgr = ServiceManager.getInstance();
        for (int i = 0; i < groups.length; ++i) {
            this.groups[i] = mgr.getOrCreateGroup(groups[i]);
            this.groups[i].setServer(this);
        }
    }

    public ServiceGroup[] getGroups() {
        if (this.groups == null) {
            this.groups = new ServiceGroup[]{ServiceManager.getInstance().getRootGroup()};
        }
        return this.groups;
    }

    public ServiceLocator getServiceLocator() throws Exception {
        if (this.serviceLocator == null) {
            this.serviceLocator = this.createServiceLocator();
        }
        return this.serviceLocator;
    }

    public void dispose() {
        if (this.groups != null) {
            for (ServiceGroup group : this.groups) {
                group.setServer(null);
            }
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
            this.serviceLocator = null;
        }
        this.serviceLocatorClass = null;
        this.properties = null;
        this.groups = null;
    }

    public Object lookup(ServiceDescriptor sd) throws Exception {
        Object service = this.getServiceLocator().lookup(sd);
        if (service == null) {
            return null;
        }
        ServiceAdapter adapter = sd.getAdapter();
        if (adapter != null) {
            return adapter.adapt(sd, service);
        }
        return service;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceHost)) {
            return false;
        }
        ServiceHost server = (ServiceHost)obj;
        return server.serviceLocatorClass == this.serviceLocatorClass;
    }

    public int hashCode() {
        return this.serviceLocatorClass != null ? this.serviceLocatorClass.hashCode() : 0;
    }
}

