/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.nuxeo.runtime.api.Framework;

public abstract class PropertyDecoder {
    private static final Map<String, PropertyDecoder> decoders = new HashMap<String, PropertyDecoder>();
    public static final PropertyDecoder STRING = new PropertyDecoder(){

        public Object decode(String value) {
            return value;
        }
    };
    public static final PropertyDecoder LIST = new PropertyDecoder(){

        public Object decode(String value) {
            ArrayList<String> values = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                tok = tok.trim();
                values.add(tok);
            }
            return values;
        }
    };
    public static final PropertyDecoder LONG = new PropertyDecoder(){

        public Object decode(String value) {
            return Long.valueOf(value);
        }
    };
    public static final PropertyDecoder INTEGER = new PropertyDecoder(){

        public Object decode(String value) {
            return Integer.valueOf(value);
        }
    };
    public static final PropertyDecoder DOUBLE = new PropertyDecoder(){

        public Object decode(String value) {
            return Double.valueOf(value);
        }
    };
    public static final PropertyDecoder FLOAT = new PropertyDecoder(){

        public Object decode(String value) {
            return Float.valueOf(value);
        }
    };
    public static final PropertyDecoder BOOLEAN = new PropertyDecoder(){

        public Object decode(String value) {
            return Boolean.valueOf(value);
        }
    };
    public static final PropertyDecoder BYTE = new PropertyDecoder(){

        public Object decode(String value) {
            return Byte.valueOf(value);
        }
    };
    public static final PropertyDecoder CHAR = new PropertyDecoder(){

        public Object decode(String value) {
            if (value.length() == 0) {
                return 0;
            }
            return Character.valueOf(value.charAt(0));
        }
    };
    public static final PropertyDecoder SHORT = new PropertyDecoder(){

        public Object decode(String value) {
            return Short.valueOf(value);
        }
    };
    public static final PropertyDecoder OBJECT = new PropertyDecoder(){

        public Object decode(String value) {
            return null;
        }
    };
    public static final PropertyDecoder CLASS = new PropertyDecoder(){

        public Object decode(String value) {
            return null;
        }
    };
    public static final PropertyDecoder INSTANCE = new PropertyDecoder(){

        public Object decode(String value) {
            return null;
        }
    };
    public static final PropertyDecoder COMPONENT = new PropertyDecoder(){

        public Object decode(String value) {
            return null;
        }
    };

    public static Object decode(String type, String value) {
        if (value != null) {
            value = Framework.getRuntime().expandVars(value);
        }
        PropertyDecoder decoder = decoders.get(type);
        try {
            return decoder == null ? value : decoder.decode(value);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static PropertyDecoder getDecoder(String type) {
        return decoders.get(type);
    }

    public static void registerDecoder(String type, PropertyDecoder decoder) {
        decoders.put(type, decoder);
    }

    public abstract Object decode(String var1);

    static {
        PropertyDecoder.registerDecoder("String", STRING);
        PropertyDecoder.registerDecoder("List", LIST);
        PropertyDecoder.registerDecoder("Long", LONG);
        PropertyDecoder.registerDecoder("Integer", INTEGER);
        PropertyDecoder.registerDecoder("Double", DOUBLE);
        PropertyDecoder.registerDecoder("Float", FLOAT);
        PropertyDecoder.registerDecoder("Boolean", BOOLEAN);
        PropertyDecoder.registerDecoder("Class", CLASS);
        PropertyDecoder.registerDecoder("Instance", INSTANCE);
        PropertyDecoder.registerDecoder("Object", OBJECT);
        PropertyDecoder.registerDecoder("Component", COMPONENT);
        PropertyDecoder.registerDecoder("Byte", BYTE);
        PropertyDecoder.registerDecoder("Char", CHAR);
        PropertyDecoder.registerDecoder("Short", SHORT);
    }
}

