/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiRuntimeService
extends AbstractRuntimeService
implements FrameworkListener {
    public static final String PROP_INSTALL_DIR = "INSTALL_DIR";
    public static final String PROP_CONFIG_DIR = "CONFIG_DIR";
    public static final String PROP_HOST_ADAPTER = "HOST_ADAPTER";
    public static final String PROP_NUXEO_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String NAME = "OSGi NXRuntime";
    public static final Version VERSION = Version.parseString("1.4.0");
    private static final Log log = LogFactory.getLog(OSGiRuntimeService.class);
    private final BundleContext bundleContext;
    private final Map<Bundle, RuntimeContext> contexts;
    private List<String> warnings = new ArrayList<String>();

    public OSGiRuntimeService(BundleContext context) {
        super(new OSGiRuntimeContext(context.getBundle()));
        this.bundleContext = context;
        this.contexts = new HashMap<Bundle, RuntimeContext>();
        this.workingDir = this.bundleContext.getDataFile("/");
        String bindAddress = context.getProperty(PROP_NUXEO_BIND_ADDRESS);
        if (bindAddress != null) {
            this.properties.put(PROP_NUXEO_BIND_ADDRESS, bindAddress);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public synchronized RuntimeContext createContext(Bundle bundle) throws Exception {
        RuntimeContext ctx = this.contexts.get(bundle);
        if (ctx == null) {
            ctx = new OSGiRuntimeContext(bundle);
            this.contexts.put(bundle, ctx);
            this.loadComponents(bundle, ctx);
        }
        return ctx;
    }

    public synchronized void destroyContext(Bundle bundle) throws Exception {
        RuntimeContext ctx = this.contexts.remove(bundle);
        if (ctx != null) {
            ctx.destroy();
        }
    }

    public synchronized RuntimeContext getContext(Bundle bundle) {
        return this.contexts.get(bundle);
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    protected void doStart() throws Exception {
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
        this.loadConfig();
        this.loadComponents(this.bundleContext.getBundle(), this.context);
    }

    @Override
    protected void doStop() throws Exception {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        super.doStop();
        this.context.destroy();
    }

    protected void loadComponents(Bundle bundle, RuntimeContext ctx) throws Exception {
        String list = OSGiRuntimeService.getComponentsList(bundle);
        if (list == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, ", \t\n\r\f");
        while (tok.hasMoreTokens()) {
            String desc = tok.nextToken();
            URL url = bundle.getEntry(desc);
            if (url != null) {
                try {
                    ctx.deploy(url);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error deploying resource: " + url));
                    throw e;
                }
            }
            String message = "Component descriptor '" + desc + "' was not found in bundle '" + bundle.getSymbolicName();
            log.warn((Object)(message + "'. Check your MANIFEST.MF"));
            this.warnings.add(message);
        }
    }

    public static String getComponentsList(Bundle bundle) {
        return (String)bundle.getHeaders().get("Nuxeo-Component");
    }

    protected void loadConfig() throws Exception {
        String configDir = this.bundleContext.getProperty(PROP_CONFIG_DIR);
        if (configDir == null) {
            return;
        }
        if (configDir.contains(":/")) {
            URL url = new URL(configDir);
            this.loadProperties(url);
            return;
        }
        File dir = new File(configDir);
        if (dir.isDirectory()) {
            for (String name : dir.list()) {
                if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml") || !name.endsWith(".config") && !name.endsWith(".ini") && !name.endsWith(".properties")) continue;
                File file = new File(dir, name);
                this.loadProperties(file);
            }
        } else {
            File file = new File(configDir);
            this.loadProperties(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadProperties(in);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            this.loadProperties(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            this.properties.put(prop.getKey().toString(), prop.getValue().toString());
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            this.printStatusMessage();
        }
    }

    private void printStatusMessage() {
        String hr = "===========================================================";
        StringBuffer msg = new StringBuffer();
        msg.append("\r\n").append(hr).append("\r\n").append("=  Nuxeo ECM Started ").append("\r\n").append(hr).append("\r\n").append("= Component Loading Warnings: ");
        if (this.warnings.isEmpty()) {
            msg.append("No Warnings");
        } else {
            for (String warning : this.warnings) {
                msg.append("\r\n").append("  * ").append(warning);
            }
        }
        Collection<ComponentName> pending = this.manager.getPendingRegistrations();
        msg.append("\r\n").append(hr).append("\r\n").append("= Component Loading Status: Pending: ").append(pending.size()).append(" / Total: ").append(this.manager.getRegistrations().size());
        if (!pending.isEmpty()) {
            msg.append("\r\n").append(hr).append("\r\n").append("= Pending Components:");
            for (ComponentName name : pending) {
                RegistrationInfo ri = this.manager.getRegistrationInfo(name);
                if (ri == null) continue;
                msg.append("\r\n").append("  > ").append(name).append(". Requires: ").append(ri.getRequiredComponents());
            }
        }
        msg.append("\r\n").append(hr).append("\r\n");
        if (this.warnings.isEmpty() && pending.isEmpty()) {
            log.info((Object)msg);
        } else {
            log.warn((Object)msg);
        }
    }
}

