/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.remoting.ServerDescriptor;
import org.nuxeo.runtime.remoting.net.NetworkNode;

public class ServerRegistry {
    private static final Log log = LogFactory.getLog(ServerRegistry.class);
    private final Map<String, ServerDescriptor> servers = new HashMap<String, ServerDescriptor>();
    private final NetworkNode node;

    public ServerRegistry(NetworkNode node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerDescriptor get(String uri) {
        ServerDescriptor sd;
        block7: {
            sd = this.servers.get(uri);
            try {
                if (sd != null) break block7;
                Map<String, ServerDescriptor> map = this.servers;
                synchronized (map) {
                    sd = this.servers.get(uri);
                    if (sd != null) {
                        return sd;
                    }
                    if (!this.node.isConnected(uri)) {
                        return null;
                    }
                    sd = new ServerDescriptor(uri);
                    this.servers.put(uri, sd);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to create server descriptor for " + uri), (Throwable)e);
            }
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String uri) {
        Map<String, ServerDescriptor> map = this.servers;
        synchronized (map) {
            ServerDescriptor sd = this.servers.remove(uri);
            if (sd != null) {
                sd.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Map<String, ServerDescriptor> map = this.servers;
        synchronized (map) {
            ServerDescriptor[] tmp;
            for (ServerDescriptor sd : tmp = this.servers.values().toArray(new ServerDescriptor[this.servers.size()])) {
                sd.destroy();
            }
            this.servers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerDescriptor[] getServers() {
        Map<String, ServerDescriptor> map = this.servers;
        synchronized (map) {
            return this.servers.values().toArray(new ServerDescriptor[this.servers.size()]);
        }
    }
}

