/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting.net.multicast;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistry;
import org.nuxeo.runtime.remoting.RemotingService;

public class ServerDetection
implements NotificationListener {
    private static final Log log = LogFactory.getLog(ServerDetection.class);
    private MulticastDetector detector;
    private NetworkRegistry registry;
    private MBeanServer mbeanServer = this.createMBeanServer();
    private final RemotingService remoting;

    public ServerDetection(RemotingService server) {
        this.remoting = server;
    }

    protected MBeanServer createMBeanServer() {
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
        return this.mbeanServer;
    }

    protected MulticastDetector createMulticastDetector(MBeanServer server) throws Exception {
        MulticastDetector detector = new MulticastDetector();
        server.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
        return detector;
    }

    protected NetworkRegistry createNetworkRegistry(MBeanServer server) throws Exception {
        NetworkRegistry registry = NetworkRegistry.getInstance();
        server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
        registry.addNotificationListener((NotificationListener)this, null, null);
        log.info((Object)"NetworkRegistry has been created");
        return registry;
    }

    public void start() throws Exception {
        this.registry = this.createNetworkRegistry(this.mbeanServer);
        this.detector = this.createMulticastDetector(this.mbeanServer);
        this.detector.start();
        log.info((Object)"MulticastDetector has been started");
    }

    public void stop() throws Exception {
        this.detector.stop();
        this.detector = null;
        this.registry = null;
        log.info((Object)"MulticastDetector has been stopped");
    }

    public NetworkRegistry getNetworkRegistry() {
        return this.registry;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof NetworkNotification) {
            NetworkNotification networkNotification = (NetworkNotification)notification;
            String type = notification.getType();
            log.debug((Object)("Got a network-registry notification: " + type));
            if ("jboss.network.server.added".equals(type) || "jboss.network.server.removed".equals(type)) {
                // empty if block
            }
        }
    }
}

