/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Properties;
import javax.naming.InitialContext;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceLocator;

public abstract class JndiServiceLocator
implements ServiceLocator {
    protected transient InitialContext context;

    public void initialize(String host, int port, Properties properties) throws Exception {
        this.context = new InitialContext();
    }

    public void dispose() {
        this.context = null;
    }

    public InitialContext getContext() {
        return this.context;
    }

    public Object lookup(ServiceDescriptor sd) throws Exception {
        String locator = sd.getLocator();
        if (locator == null) {
            locator = JndiServiceLocator.createLocator(sd);
            sd.setLocator(locator);
        }
        return this.lookup(locator);
    }

    public Object lookup(String serviceId) throws Exception {
        return this.context.lookup(serviceId);
    }

    protected static String createLocator(ServiceDescriptor sd) {
        return sd.getServiceClassName();
    }
}

