/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.io.Serializable;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.ServiceAdapter;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="service", order={"serviceClass", "name"})
public class ServiceDescriptor
implements Serializable {
    private static final long serialVersionUID = 5490362136607217161L;
    @XNode(value="@name")
    private String name;
    private String serviceClassName;
    private transient Class<?> serviceClass;
    @XNode(value="adapter")
    private Class<ServiceAdapter> adapterClass;
    private ServiceAdapter adapter;
    @XNode(value="locator")
    private String locatorPattern;
    private transient String locator;
    private ServiceGroup group;

    @XNode(value="@class")
    void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
        this.serviceClassName = serviceClass.getName();
    }

    public ServiceDescriptor() {
    }

    public ServiceDescriptor(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public ServiceDescriptor(String serviceClassName, String group) {
        this.serviceClassName = serviceClassName;
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
    }

    public ServiceDescriptor(String serviceClassName, String group, String name) {
        this.serviceClassName = serviceClassName;
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
        this.name = name;
    }

    public ServiceDescriptor(Class<?> serviceClass) {
        this.setServiceClass(serviceClass);
    }

    public ServiceDescriptor(Class<?> serviceClass, String group) {
        this.setServiceClass(serviceClass);
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
    }

    public ServiceDescriptor(Class<?> serviceClass, String group, String name) {
        this.setServiceClass(serviceClass);
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
        this.name = name;
    }

    @XNode(value="@group")
    public void setGroup(String group) {
        this.group = ServiceManager.getInstance().getOrCreateGroup(group);
    }

    public ServiceGroup getGroup() {
        return this.group;
    }

    public ServiceHost getServer() {
        return this.group.getServer();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public String getServiceClassSimpleName() {
        int p = this.serviceClassName.lastIndexOf(46);
        if (p == -1) {
            return this.serviceClassName;
        }
        return this.serviceClassName.substring(p + 1);
    }

    Class<?> getServiceClass() throws ClassNotFoundException {
        if (this.serviceClass == null) {
            this.serviceClass = Thread.currentThread().getContextClassLoader().loadClass(this.serviceClassName);
        }
        return this.serviceClass;
    }

    public String getInstanceName() {
        return this.name != null ? this.serviceClassName + '#' + this.name : this.serviceClassName;
    }

    public String getLocator() {
        return this.locator == null ? this.locatorPattern : this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public ServiceAdapter getAdapter() throws Exception {
        if (this.adapterClass == null) {
            return null;
        }
        if (this.adapter == null) {
            this.adapter = this.adapterClass.newInstance();
        }
        return this.adapter;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ServiceDescriptor) {
            ServiceDescriptor sd = (ServiceDescriptor)obj;
            if (!this.serviceClassName.equals(sd.serviceClassName)) {
                return false;
            }
            if (this.name != null ? !this.name.equals(sd.name) : this.name != sd.name) {
                return false;
            }
            return this.group.getName().equals(sd.group.getName());
        }
        return false;
    }
}

