/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config;

import java.util.Map;
import java.util.Properties;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.config.AutoConfigurationService;
import org.nuxeo.runtime.config.ServerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerConfiguration
implements ServerConfiguration {
    private static final long serialVersionUID = 1970555604877434479L;
    protected String name;
    protected Version version;
    protected Properties properties;
    protected Properties jndiProperties;
    protected SecurityDomain[] securityDomains;
    protected Map<String, String> serviceBindings;
    protected String streamingLocator;
    protected String[] peers;
    protected InvokerLocator locator;

    public AbstractServerConfiguration(InvokerLocator locator, String name, Version version) {
        this.locator = locator;
        this.name = name;
        this.version = version;
    }

    @Override
    public InvokerLocator getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getProductInfo() {
        String name = Framework.getRuntime().getProperty("org.nuxeo.ecm.product.name");
        String version = Framework.getRuntime().getProperty("org.nuxeo.ecm.product.version");
        if (name == null) {
            name = "Nuxeo Runtime Server";
            version = Framework.getRuntime().getVersion().toString();
        } else if (version == null) {
            version = "0.0.0";
        }
        return name + ' ' + version;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, String> getServiceBindings() {
        return this.serviceBindings;
    }

    public void setServiceBindings(Map<String, String> bindings) {
        this.serviceBindings = bindings;
    }

    public SecurityDomain[] getSecurityDomains() {
        return this.securityDomains;
    }

    public void setSecurityDomains(SecurityDomain[] domains) {
        this.securityDomains = domains;
    }

    public String getStreamingLocator() {
        return this.streamingLocator;
    }

    public void setStreamingLocator(String locator) {
        this.streamingLocator = locator;
    }

    @Override
    public String[] getPeers() {
        return this.peers;
    }

    public void setPeers(String[] peers) {
        this.peers = peers;
    }

    @Override
    public Properties getJndiProperties() {
        if (this.jndiProperties == null) {
            this.jndiProperties = AutoConfigurationService.readJndiProperties(this.properties);
        }
        return this.jndiProperties;
    }

    public void setJndiProperties(Properties jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    @Override
    public abstract void install() throws Exception;
}

