/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.lang.reflect.Method;
import java.util.Set;
import org.nuxeo.runtime.model.Adaptable;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.Property;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInstanceImpl
implements ComponentInstance {
    protected Object instance;
    protected RegistrationInfoImpl ri;

    protected ComponentInstanceImpl() {
    }

    public ComponentInstanceImpl(RegistrationInfoImpl ri) throws Exception {
        this.ri = ri;
        this.instance = ri.implementation == null ? this : this.ri.context.loadClass(this.ri.implementation).newInstance();
    }

    @Override
    public Object getInstance() {
        switch (this.ri.state) {
            case 2: {
                try {
                    this.ri.activate();
                    return this.instance;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 3: {
                return this.instance;
            }
        }
        return null;
    }

    public void create() throws Exception {
        this.instance = this.ri.implementation == null ? this : this.ri.context.loadClass(this.ri.implementation).newInstance();
    }

    @Override
    public void destroy() throws Exception {
        this.deactivate();
        this.instance = null;
        this.ri = null;
    }

    @Override
    public RuntimeContext getContext() {
        return this.ri.context;
    }

    @Override
    public ComponentName getName() {
        return this.ri.name;
    }

    @Override
    public void activate() throws Exception {
        if (this.instance instanceof Component) {
            ((Component)this.instance).activate(this);
        } else {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("activate", ComponentContext.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void deactivate() throws Exception {
        if (this.instance instanceof Component) {
            ((Component)this.instance).deactivate(this);
        } else {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("deactivate", ComponentContext.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void registerExtension(Extension extension) throws Exception {
        if (this.instance instanceof Component) {
            ((Component)this.instance).registerExtension(extension);
        } else {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("registerExtension", Extension.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, extension);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void unregisterExtension(Extension extension) throws Exception {
        if (this.instance instanceof Component) {
            ((Component)this.instance).unregisterExtension(extension);
        } else {
            try {
                Method meth = this.instance.getClass().getDeclaredMethod("unregisterExtension", Extension.class);
                meth.setAccessible(true);
                meth.invoke(this.instance, extension);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object object = this.getInstance();
        if (object instanceof Adaptable) {
            return ((Adaptable)object).getAdapter(adapter);
        }
        if (adapter.isAssignableFrom(object.getClass())) {
            return adapter.cast(object);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        Set<String> set = this.ri.getProperties().keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Property getProperty(String property) {
        return this.ri.getProperties().get(property);
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.ri.getContext();
    }

    @Override
    public Object getPropertyValue(String property) {
        return this.getPropertyValue(property, null);
    }

    @Override
    public Object getPropertyValue(String property, Object defValue) {
        Property prop = this.getProperty(property);
        if (prop != null) {
            return prop.getValue();
        }
        return defValue;
    }
}

