/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiComponentLoader
implements SynchronousBundleListener {
    private final OSGiRuntimeService runtime;

    public OSGiComponentLoader(OSGiRuntimeService runtime) {
        this.runtime = runtime;
        this.install();
    }

    public void install() {
        BundleContext ctx = this.runtime.getBundleContext();
        ctx.addBundleListener((BundleListener)this);
        Bundle[] bundles = ctx.getBundles();
        int mask = 44;
        for (Bundle bundle : bundles) {
            int state = bundle.getState();
            if ((state & mask) == 0 || OSGiRuntimeService.getComponentsList(bundle) == null) continue;
            try {
                this.runtime.createContext(bundle);
            }
            catch (Throwable e) {
                System.out.println("Failed to load components for bundle - " + bundle.getSymbolicName());
                e.printStackTrace();
            }
        }
    }

    public void uninstall() {
        this.runtime.getBundleContext().removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        try {
            Bundle bundle = event.getBundle();
            int type = event.getType();
            switch (type) {
                case 32: {
                    if (OSGiRuntimeService.getComponentsList(bundle) == null) break;
                    this.runtime.createContext(bundle);
                    break;
                }
                case 64: {
                    if (OSGiRuntimeService.getComponentsList(bundle) == null) break;
                    this.runtime.destroyContext(bundle);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

