/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.config.Configuration;
import org.nuxeo.runtime.config.ServerConfiguration;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.Server;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoConfigurationService {
    ServerConfiguration config;
    ServiceManager serviceMgr;
    LoginService loginMgr;
    RemotingService remoting;
    Version version = new Version(1, 0, 0);
    private static final String JNDI_PREFIX = "nuxeo-client-jndi.";

    public AutoConfigurationService() {
        this.remoting = Framework.getLocalService(RemotingService.class);
        this.serviceMgr = Framework.getLocalService(ServiceManager.class);
        this.loginMgr = Framework.getLocalService(LoginService.class);
    }

    public Version getVersion() {
        return this.version;
    }

    public void clear() {
        this.serviceMgr.removeServices();
        this.serviceMgr.removeGroups();
        this.serviceMgr.removeServers();
        this.loginMgr.removeSecurityDomains();
    }

    public void load(String uri) throws Exception {
        this.load(new InvokerLocator(uri));
    }

    public void load(String protocol, String host, int port) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("datatype", "nuxeo");
        this.load(new InvokerLocator(protocol, host, port, "/", params));
    }

    public void load(String host, int port) throws Exception {
        this.load("socket", host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InvokerLocator locator) throws Exception {
        Server server = null;
        try {
            server = (Server)TransporterClient.createTransporterClient(locator, Server.class);
            try {
                this.clear();
                this.config = server.getConfiguration(locator, this.version);
                this.config.install();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loadCompat(server, locator);
            }
        }
        finally {
            if (server != null) {
                TransporterClient.destroyTransporterClient(server);
            }
        }
    }

    public ServerConfiguration getServerConfiguration() {
        return this.config;
    }

    protected void loadCompat(Server server, InvokerLocator locator) throws Exception {
        new Configuration().load(server, locator.getHost(), locator.getLocatorURI());
    }

    public static Properties readJndiProperties(Properties properties) {
        Properties jndiProperties = new Properties();
        int prefixLen = JNDI_PREFIX.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(JNDI_PREFIX)) continue;
            jndiProperties.put(key.substring(prefixLen), entry.getValue());
        }
        return jndiProperties;
    }

    public static InvokerLocator createLocator(String url) throws MalformedURLException {
        InvokerLocator locator = new InvokerLocator(url);
        return AutoConfigurationService.createLocator(locator.getProtocol(), locator.getHost(), locator.getPort(), locator.getPath(), locator.getParameters());
    }

    public static InvokerLocator createLocator(String host, int port) {
        return AutoConfigurationService.createLocator("socket", host, port, "", null);
    }

    public static InvokerLocator createLocator(String protocol, String host, int port) {
        return AutoConfigurationService.createLocator(protocol, host, port, "", null);
    }

    public static InvokerLocator createLocator(String protocol, String host, int port, String path) {
        return AutoConfigurationService.createLocator(protocol, host, port, path, null);
    }

    public static InvokerLocator createLocator(String protocol, String host, int port, String path, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
            params.put("datatype", "nuxeo");
        }
        return new InvokerLocator(protocol, host, port, path, params);
    }
}

