/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config.v1;

import java.util.Map;
import java.util.Properties;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.config.AutoConfigurationService;
import org.nuxeo.runtime.config.ConfigurationException;
import org.nuxeo.runtime.config.ConfigurationFactory;
import org.nuxeo.runtime.config.ConfigurationHelper;
import org.nuxeo.runtime.config.ServerConfiguration;
import org.nuxeo.runtime.config.v1.ServerConfiguration1;
import org.nuxeo.runtime.services.streaming.StreamingService;

public class ConfigurationFactory1
extends ConfigurationFactory {
    public static final Version VERSION = new Version(1, 0, 0);

    public Version getVersion() {
        return VERSION;
    }

    public ServerConfiguration createConfiguration(InvokerLocator locator, Version version) throws ConfigurationException {
        String name = Framework.getProperty("org.nuxeo.runtime.server.name");
        ServerConfiguration1 config = new ServerConfiguration1(locator, name, VERSION);
        config.setProperties(this.getProperties());
        config.setSecurityDomains(this.getSecurityDomains());
        StreamingService streaming = (StreamingService)Framework.getRuntime().getComponent(StreamingService.NAME);
        if (streaming.isServer()) {
            config.setStreamingLocator(locator.getLocatorURI());
        } else {
            String uri = streaming.getServerLocator();
            String normalizedUri = ConfigurationHelper.getNormalizedURI(uri, locator.getHost());
            if (normalizedUri != null) {
                uri = normalizedUri;
            }
            config.setStreamingLocator(uri);
        }
        config.setServiceBindingsCompat(this.getServiceBindings());
        config.setServiceHostsCompat(this.getServiceHosts(locator.getHost()));
        return config;
    }

    public ServiceDescriptor[] getServiceBindings() {
        ServiceManager sm = Framework.getLocalService(ServiceManager.class);
        return sm.getServiceDescriptors();
    }

    public ServiceHost[] getServiceHosts(String host) throws ConfigurationException {
        ServiceHost[] serviceHosts;
        ServiceManager sm = Framework.getLocalService(ServiceManager.class);
        for (ServiceHost shost : serviceHosts = sm.getServers()) {
            String h = shost.getHost();
            int p = shost.getPort();
            Properties props = shost.getProperties();
            if (h == null) {
                shost.setAddress(host, p);
            } else {
                String newHost = ConfigurationHelper.getNormalizedHost(h, host);
                if (newHost != null) {
                    shost.setAddress(newHost, shost.getPort());
                }
            }
            if (props != null && !props.isEmpty()) continue;
            this.updateLocalHostJndiProps(shost);
        }
        return serviceHosts;
    }

    private void updateLocalHostJndiProps(ServiceHost host) {
        Properties runtimeProps = Framework.getRuntime().getProperties();
        Properties props = AutoConfigurationService.readJndiProperties(runtimeProps);
        if (!props.isEmpty()) {
            host.setProperties(props);
        }
    }

    public SecurityDomain[] getSecurityDomains() {
        LoginService loginService = Framework.getLocalService(LoginService.class);
        return loginService.getSecurityDomains();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        Properties rtProps = Framework.getRuntime().getProperties();
        for (Map.Entry<Object, Object> entry : rtProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = Framework.expandVars(entry.getValue().toString());
            props.put(key, value);
        }
        return props;
    }

    public Properties getJNDIProperties() {
        return AutoConfigurationService.readJndiProperties(Framework.getRuntime().getProperties());
    }
}

