/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting.transporter;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.NameBasedInvocation;

public class TransporterHandler
implements ServerInvocationHandler {
    private final Object targetPOJO;

    public TransporterHandler(Object target) {
        this.targetPOJO = target;
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        Object request = invocation.getParameter();
        NameBasedInvocation nbInvocation = (NameBasedInvocation)request;
        String methodName = nbInvocation.getMethodName();
        Object[] params = nbInvocation.getParameters();
        String[] sig = nbInvocation.getSignature();
        Class[] classSig = new Class[sig.length];
        for (int x = 0; x < sig.length; ++x) {
            Class signature = this.getPrimitiveType(sig[x]);
            classSig[x] = signature != null ? signature : Class.forName(sig[x]);
        }
        Method method = this.targetPOJO.getClass().getMethod(methodName, classSig);
        return method.invoke(this.targetPOJO, params);
    }

    public void setMBeanServer(MBeanServer server) {
    }

    public void setInvoker(ServerInvoker invoker) {
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }

    private Class getPrimitiveType(String name) {
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }
}

