/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.remoting.RemoteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentManagerImpl
implements ComponentManager {
    private static final Log log = LogFactory.getLog(ComponentManager.class);
    protected final Map<ComponentName, Set<Extension>> pendingExtensions;
    private ListenerList listeners;
    private Map<ComponentName, RegistrationInfoImpl> registry = new HashMap<ComponentName, RegistrationInfoImpl>();
    private Map<ComponentName, Set<RegistrationInfoImpl>> dependsOnMe = new HashMap<ComponentName, Set<RegistrationInfoImpl>>();
    private final Map<String, RegistrationInfoImpl> services;

    public ComponentManagerImpl(RuntimeService runtime) {
        this.pendingExtensions = new HashMap<ComponentName, Set<Extension>>();
        this.listeners = new ListenerList();
        this.services = new Hashtable<String, RegistrationInfoImpl>();
    }

    @Override
    public Collection<RegistrationInfo> getRegistrations() {
        return new ArrayList<RegistrationInfo>(this.registry.values());
    }

    @Override
    public Map<ComponentName, Set<ComponentName>> getPendingRegistrations() {
        HashMap<ComponentName, Set<ComponentName>> pending = new HashMap<ComponentName, Set<ComponentName>>();
        for (RegistrationInfoImpl registrationInfoImpl : this.registry.values()) {
            if (registrationInfoImpl.getState() != 1) continue;
            pending.put(registrationInfoImpl.getName(), registrationInfoImpl.getRequiredComponents());
        }
        for (Map.Entry entry : this.dependsOnMe.entrySet()) {
            for (RegistrationInfoImpl ri : (Set)entry.getValue()) {
                HashSet deps = new HashSet(1);
                deps.add(entry.getKey());
                pending.put(ri.getName(), deps);
            }
        }
        return pending;
    }

    public Collection<ComponentName> getNeededRegistrations() {
        return this.pendingExtensions.keySet();
    }

    public Collection<Extension> getPendingExtensions(ComponentName name) {
        return this.pendingExtensions.get(name);
    }

    @Override
    public RegistrationInfo getRegistrationInfo(ComponentName name) {
        return this.registry.get(name);
    }

    @Override
    public synchronized boolean isRegistered(ComponentName name) {
        return this.registry.containsKey(name);
    }

    @Override
    public synchronized int size() {
        return this.registry.size();
    }

    @Override
    public ComponentInstance getComponent(ComponentName name) {
        RegistrationInfoImpl ri = this.registry.get(name);
        return ri != null ? ri.getComponent() : null;
    }

    @Override
    public synchronized void shutdown() {
        ArrayList<RegistrationInfoImpl> elems = new ArrayList<RegistrationInfoImpl>(this.registry.values());
        for (RegistrationInfo registrationInfo : elems) {
            try {
                this.unregister(registrationInfo);
            }
            catch (Exception e) {
                log.error((Object)"failed to shutdown component manager", (Throwable)e);
            }
        }
        try {
            this.listeners = null;
            this.registry.clear();
            this.registry = null;
            this.dependsOnMe.clear();
            this.dependsOnMe = null;
        }
        catch (Exception e) {
            log.error((Object)"Failed to shutdown registry manager");
        }
    }

    @Override
    public synchronized void register(RegistrationInfo regInfo) {
        this._register((RegistrationInfoImpl)regInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void _register(RegistrationInfoImpl ri) {
        ComponentName name = ri.getName();
        if (this.isRegistered(name)) {
            if (name.getName().startsWith("org.nuxeo.runtime.")) {
                return;
            }
            String msg = "Duplicate component name: '" + name + "'";
            log.error((Object)msg);
            Framework.getRuntime().getWarnings().add(msg);
            return;
        }
        ri.manager = this;
        try {
            ri.register();
        }
        catch (Exception e) {
            log.error((Object)("Failed to register component: " + ri.getName()), (Throwable)e);
            return;
        }
        boolean hasBlockingDeps = this.computeBlockingDependencies(ri);
        if (!hasBlockingDeps) {
            Set<RegistrationInfoImpl> pendings = this.removeDependencies(name);
            ri.dependsOnMe = pendings;
            log.info((Object)("Registering component: " + ri.getName()));
            try {
                this.registry.put(ri.name, ri);
                ri.resolve();
                if (ri.dependsOnMe == null) return;
                for (RegistrationInfoImpl pending : ri.dependsOnMe) {
                    if (pending.waitsFor == null) {
                        this._register(pending);
                        continue;
                    }
                    pending.waitsFor.remove(name);
                    if (!pending.waitsFor.isEmpty()) continue;
                    pending.waitsFor = null;
                    this._register(pending);
                }
                return;
            }
            catch (Throwable e) {
                log.error((Object)("Failed to create component: " + ri.name), e);
                return;
            }
        } else {
            log.info((Object)("Registration delayed for component: " + name + ". Waiting for: " + ri.waitsFor));
        }
    }

    @Override
    public synchronized void unregister(RegistrationInfo regInfo) {
        this._unregister((RegistrationInfoImpl)regInfo);
    }

    public final void _unregister(RegistrationInfoImpl ri) {
        if (ri.requires != null) {
            for (ComponentName dep : ri.requires) {
                RegistrationInfoImpl depRi = this.registry.get(dep);
                if (depRi == null || depRi.dependsOnMe == null) continue;
                depRi.dependsOnMe.remove(ri);
            }
        }
        if (ri.dependsOnMe != null) {
            ArrayList<RegistrationInfoImpl> deps = new ArrayList<RegistrationInfoImpl>(ri.dependsOnMe);
            for (RegistrationInfoImpl dep : deps) {
                try {
                    dep.unresolve();
                    if (dep.waitsFor == null) {
                        dep.waitsFor = new HashSet<ComponentName>();
                    }
                    dep.waitsFor.add(ri.name);
                    this.addDependency(ri.name, dep);
                    this.registry.remove(dep);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to unresolve component: " + dep.getName()), (Throwable)e);
                }
            }
        }
        log.info((Object)("Unregistering component: " + ri.name));
        try {
            if (this.registry.remove(ri.name) == null) {
                // empty if block
            }
            ri.unregister();
        }
        catch (Exception e) {
            log.error((Object)("Failed to unregister component: " + ri.getName()), (Throwable)e);
        }
    }

    @Override
    public synchronized void unregister(ComponentName name) {
        RegistrationInfoImpl ri = this.registry.get(name);
        if (ri != null) {
            this._unregister(ri);
        }
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.listeners.remove((Object)listener);
    }

    void sendEvent(ComponentEvent event) {
        Object[] listeners;
        log.debug((Object)("Dispatching event: " + event));
        for (Object listener : listeners = this.listeners.getListeners()) {
            ((ComponentListener)listener).handleEvent(event);
        }
    }

    protected boolean computeBlockingDependencies(RegistrationInfoImpl ri) {
        if (ri.requires != null) {
            for (ComponentName dep : ri.requires) {
                RegistrationInfoImpl depRi = this.registry.get(dep);
                if (depRi == null) {
                    if (ri.waitsFor == null) {
                        ri.waitsFor = new HashSet<ComponentName>();
                    }
                    ri.waitsFor.add(dep);
                    this.addDependency(dep, ri);
                    continue;
                }
                if (depRi.dependsOnMe == null) {
                    depRi.dependsOnMe = new HashSet<RegistrationInfoImpl>();
                }
                depRi.dependsOnMe.add(ri);
            }
        }
        return ri.waitsFor != null;
    }

    protected synchronized void addDependency(ComponentName name, RegistrationInfoImpl dependent) {
        Set<RegistrationInfoImpl> pendings = this.dependsOnMe.get(name);
        if (pendings == null) {
            pendings = new HashSet<RegistrationInfoImpl>();
            this.dependsOnMe.put(name, pendings);
        }
        pendings.add(dependent);
    }

    protected synchronized Set<RegistrationInfoImpl> removeDependencies(ComponentName name) {
        return this.dependsOnMe.remove(name);
    }

    public void registerExtension(Extension extension) throws Exception {
        ComponentName name = extension.getTargetComponent();
        RegistrationInfoImpl ri = this.registry.get(name);
        if (ri != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register contributed extension: " + extension));
            }
            ComponentManagerImpl.loadContributions(ri, extension);
            ri.component.registerExtension(extension);
            if (!(extension.getContext() instanceof RemoteContext)) {
                this.sendEvent(new ComponentEvent(9, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
            }
        } else {
            Set<Extension> extensions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enqueue contributed extension to pending queue: " + extension));
            }
            if ((extensions = this.pendingExtensions.get(name)) == null) {
                extensions = new LinkedHashSet<Extension>();
                this.pendingExtensions.put(name, extensions);
            }
            extensions.add(extension);
            if (!(extension.getContext() instanceof RemoteContext)) {
                this.sendEvent(new ComponentEvent(11, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
            }
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        ComponentName name;
        RegistrationInfo ri;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregister contributed extension: " + extension));
        }
        if ((ri = (RegistrationInfo)this.registry.get(name = extension.getTargetComponent())) != null) {
            ComponentInstance co = ri.getComponent();
            if (co != null) {
                co.unregisterExtension(extension);
            }
        } else {
            Set<Extension> extensions = this.pendingExtensions.get(name);
            if (extensions != null) {
                extensions.remove(name);
                if (extensions.isEmpty()) {
                    this.pendingExtensions.remove(name);
                }
            }
        }
        if (!(extension.getContext() instanceof RemoteContext)) {
            this.sendEvent(new ComponentEvent(10, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        }
    }

    public static void loadContributions(RegistrationInfoImpl ri, Extension xt) {
        ExtensionPointImpl xp = ri.getExtensionPoint(xt.getExtensionPoint());
        if (xp != null && xp.contributions != null) {
            try {
                Object[] contribs = xp.loadContributions(ri, xt);
                xt.setContributions(contribs);
            }
            catch (Exception e) {
                log.error((Object)"Failed to create contribution objects", (Throwable)e);
            }
        }
    }

    public void registerServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            log.info((Object)("Registering service: " + service));
            this.services.put(service, ri);
        }
    }

    public void unregisterServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            this.services.remove(service);
        }
    }

    public String[] getServices() {
        return this.services.keySet().toArray(new String[this.services.size()]);
    }

    @Override
    public ComponentInstance getComponentProvidingService(Class<?> serviceClass) {
        try {
            RegistrationInfoImpl ri = this.services.get(serviceClass.getName());
            if (ri != null) {
                if (!ri.isActivated()) {
                    if (ri.isResolved()) {
                        ri.activate();
                    } else {
                        if (!serviceClass.getSimpleName().equals("TypeProvider")) {
                            log.debug((Object)("The component exposing the service " + serviceClass + " is not resolved"));
                        }
                        return null;
                    }
                }
                return ri.getComponent();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get service: " + serviceClass));
        }
        return null;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        ComponentInstance comp = this.getComponentProvidingService(serviceClass);
        return comp != null ? (T)comp.getAdapter(serviceClass) : null;
    }

    @Override
    public Collection<ComponentName> getActivatingRegistrations() {
        ArrayList<ComponentName> activating = new ArrayList<ComponentName>();
        for (RegistrationInfoImpl ri : this.registry.values()) {
            if (ri.getState() != 4) continue;
            activating.add(ri.getName());
        }
        return activating;
    }
}

