/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.net.URL;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiRuntimeContext
extends DefaultRuntimeContext {
    protected final Bundle bundle;
    protected String hostBundleId;
    protected Bundle hostBundle;

    public OSGiRuntimeContext(Bundle bundle) {
        this(Framework.getRuntime(), bundle);
    }

    public OSGiRuntimeContext(RuntimeService runtime, Bundle bundle) {
        super(runtime);
        int p;
        this.bundle = bundle;
        this.hostBundleId = (String)bundle.getHeaders().get("Fragment-Host");
        if (this.hostBundleId != null && (p = this.hostBundleId.indexOf(59)) > -1) {
            this.hostBundleId = this.hostBundleId.substring(0, p);
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public URL getResource(String name) {
        if (this.hostBundleId != null) {
            return this.getHostBundle().getResource(name);
        }
        return this.bundle.getResource(name);
    }

    @Override
    public URL getLocalResource(String name) {
        if (this.hostBundleId != null) {
            return this.getHostBundle().getEntry(name);
        }
        return this.bundle.getEntry(name);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        if (this.hostBundleId != null) {
            return this.getHostBundle().loadClass(className);
        }
        return this.bundle.loadClass(className);
    }

    public Bundle getHostBundle() {
        if (this.hostBundleId != null && this.hostBundle == null && this.runtime instanceof OSGiRuntimeService) {
            this.hostBundle = ((OSGiRuntimeService)this.runtime).findHostBundle(this.bundle);
        }
        return this.hostBundle;
    }
}

