/*
 * (C) Copyright 2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime;

/**
 * A runtime extension is a service that is started by the runtime when it
 * starts using the runtime service context.
 * <p>
 * Runtime Extensions may be used to add new functionality to the runtime service.
 *
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 */
public interface RuntimeExtension {

    /**
     * Starts the runtime extension.
     * <p>
     * The current runtime is available as <code>Runtime.getRuntime()</code>.
     *
     * @throws Exception
     */
    void start() throws Exception;

    /**
     * Stops the runtime extension.
     * <p>
     * The current runtime is available as <code>Runtime.getRuntime()</code>.
     *
     * @throws Exception
     */
    void stop() throws Exception;

}
