/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemLoginRestrictionManager {
    public static final String RESTRICT_REMOTE_SYSTEM_LOGIN_PROP = "org.nuxeo.systemlogin.restrict";
    public static final String REMOTE_SYSTEM_LOGIN_TRUSTED_INSTANCES_PROP = "org.nuxeo.systemlogin.trusted.instances";
    public static final String TRUSTED_INSTANCES_SEP = ",";
    protected Boolean restrictRemoteSystemLogin = null;
    protected List<String> allowedInstancesForSystemLogin = null;
    protected static Log log = LogFactory.getLog(SystemLoginRestrictionManager.class);

    public boolean isRemoteSystemLoginRestricted() {
        if (this.restrictRemoteSystemLogin == null) {
            this.restrictRemoteSystemLogin = Framework.getProperty(RESTRICT_REMOTE_SYSTEM_LOGIN_PROP, "true").equalsIgnoreCase("false") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.restrictRemoteSystemLogin;
    }

    public List<String> getAllowedInstanceForSystemLogin() {
        if (this.allowedInstancesForSystemLogin == null) {
            String instanceKeys = Framework.getProperty(REMOTE_SYSTEM_LOGIN_TRUSTED_INSTANCES_PROP, null);
            if (instanceKeys != null) {
                if ((instanceKeys = instanceKeys.trim()).endsWith(TRUSTED_INSTANCES_SEP)) {
                    instanceKeys = instanceKeys.substring(0, instanceKeys.length() - 1);
                }
                this.allowedInstancesForSystemLogin = Arrays.asList(instanceKeys.split(TRUSTED_INSTANCES_SEP));
            } else {
                this.allowedInstancesForSystemLogin = new ArrayList<String>();
            }
        }
        return this.allowedInstancesForSystemLogin;
    }

    public boolean isRemoveSystemLoginAllowedForInstance(String instanceId) {
        return this.getAllowedInstanceForSystemLogin().contains(instanceId);
    }
}

