/*
 * (C) Copyright 2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.services.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public class ByteArraySource extends AbstractStreamSource {

    protected final byte[] bytes;


    public ByteArraySource(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public long getLength() throws IOException {
        return bytes.length;
    }

    @Override
    public boolean canReopen() {
        return true;
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public byte[] getBytes() throws IOException {
        return bytes;
    }

}
