/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.nuxeo.runtime.binding.AbstractServiceProvider;
import org.nuxeo.runtime.binding.JndiBinding;
import org.nuxeo.runtime.binding.JndiName;

public class BeanServiceProvider
extends AbstractServiceProvider {
    public static final String PREFIX = "nxservice";
    public static final String REMOTE_SUFFIX = "remote";
    public static final String LOCAL_SUFFIX = "local";
    protected Context ctx;
    protected boolean tryLocalFirst = true;

    public BeanServiceProvider() throws NamingException {
        this(new InitialContext(), false);
    }

    public BeanServiceProvider(InitialContext ctx) throws NamingException {
        this(ctx, true);
    }

    public BeanServiceProvider(InitialContext ctx, boolean tryLocalFirst) throws NamingException {
        this.tryLocalFirst = tryLocalFirst;
        JndiName comp = new JndiName(PREFIX);
        try {
            this.ctx = (Context)ctx.lookup(comp);
        }
        catch (NameNotFoundException e) {
            this.ctx = ctx.createSubcontext(comp);
        }
    }

    @Override
    public void destroy() {
        this.ctx = null;
    }

    @Override
    public Object getService(Class<?> serviceClass, String bindingKey) {
        try {
            Object obj;
            JndiName name;
            if (this.tryLocalFirst) {
                name = new JndiName(bindingKey, LOCAL_SUFFIX);
                obj = this.ctx.lookup(name);
                if (this.manager != null) {
                    JndiBinding binding = new JndiBinding(bindingKey, this.ctx, name);
                    this.manager.registerBinding(bindingKey, binding);
                    return obj;
                }
            }
            name = new JndiName(bindingKey, REMOTE_SUFFIX);
            obj = this.ctx.lookup(name);
            if (this.manager != null) {
                JndiBinding binding = new JndiBinding(bindingKey, this.ctx, name);
                this.manager.registerBinding(bindingKey, binding);
            }
            return obj;
        }
        catch (NamingException namingException) {
            return null;
        }
    }
}

