/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.persistence.Contribution;
import org.nuxeo.runtime.model.persistence.ContributionPersistenceManager;
import org.nuxeo.runtime.model.persistence.ContributionStorage;
import org.nuxeo.runtime.model.persistence.ContributionStorageDescriptor;
import org.nuxeo.runtime.model.persistence.fs.FileSystemStorage;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class ContributionPersistenceComponent
extends DefaultComponent
implements ContributionPersistenceManager,
FrameworkListener {
    private static final Log log = LogFactory.getLog(ContributionPersistenceComponent.class);
    public static final String STORAGE_XP = "storage";
    protected ContributionStorage storage;
    protected RuntimeContext ctx;

    public static String getComponentName(String contribName) {
        return "config:" + contribName;
    }

    @Override
    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.ctx = context.getRuntimeContext();
        this.storage = new FileSystemStorage();
        this.ctx.getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
    }

    @Override
    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.ctx = null;
        this.storage = null;
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        ContributionStorageDescriptor c = (ContributionStorageDescriptor)contribution;
        this.storage = (ContributionStorage)c.clazz.newInstance();
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        this.storage = null;
    }

    @Override
    public List<Contribution> getContributions() throws Exception {
        return this.storage.getContributions();
    }

    @Override
    public Contribution getContribution(String name) throws Exception {
        return this.storage.getContribution(name);
    }

    @Override
    public Contribution addContribution(Contribution contrib) throws Exception {
        return this.storage.addContribution(contrib);
    }

    @Override
    public boolean removeContribution(Contribution contrib) throws Exception {
        return this.storage.removeContribution(contrib);
    }

    @Override
    public boolean isInstalled(Contribution contrib) throws Exception {
        return this.ctx.isDeployed(contrib);
    }

    @Override
    public synchronized boolean installContribution(Contribution contrib) throws Exception {
        RegistrationInfo ri = this.ctx.deploy(contrib);
        if (ri == null) {
            return false;
        }
        ri.setPersistent(true);
        return true;
    }

    @Override
    public boolean uninstallContribution(Contribution contrib) throws Exception {
        boolean ret = this.isInstalled(contrib);
        this.ctx.undeploy(contrib);
        return ret;
    }

    @Override
    public Contribution updateContribution(Contribution contribution) throws Exception {
        return this.storage.updateContribution(contribution);
    }

    @Override
    public boolean isPersisted(Contribution contrib) throws Exception {
        return this.storage.getContribution(contrib.getName()) != null;
    }

    @Override
    public void start() throws Exception {
        for (Contribution c : this.storage.getContributions()) {
            if (c.isDisabled()) continue;
            this.installContribution(c);
        }
    }

    @Override
    public void stop() throws Exception {
        for (Contribution c : this.storage.getContributions()) {
            if (c.isDisabled()) continue;
            this.uninstallContribution(c);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1 && this.storage == null) {
            this.storage = new FileSystemStorage();
            try {
                this.start();
            }
            catch (Exception e) {
                log.error((Object)"Failed to start contribution persistence service", (Throwable)e);
            }
        }
    }
}

