/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.transaction.Transacted;
import org.nuxeo.runtime.transaction.TransactedServiceProvider;

public abstract class AnnotatedServiceProvider
implements ServiceProvider {
    protected static final Log log = LogFactory.getLog(TransactedServiceProvider.class);
    protected ServiceProvider nextProvider;
    boolean installed = false;
    protected Map<Class<?>, Entry<?>> registry = new HashMap();

    public void installSelf() {
        if (this.installed) {
            return;
        }
        this.installed = true;
        this.nextProvider = DefaultServiceProvider.getProvider();
        DefaultServiceProvider.setProvider(this);
    }

    protected abstract Class<? extends Annotation> annotationClass();

    protected abstract <T> T newProxy(T var1, Class<T> var2);

    @Override
    public <T> T getService(Class<T> srvClass) {
        if (!this.registry.containsKey(srvClass)) {
            this.registry.put(srvClass, new Entry<T>(srvClass));
        }
        return srvClass.cast(this.registry.get(srvClass).getService());
    }

    protected class Entry<T> {
        final Class<T> srvClass;
        final boolean isAnnoted;

        protected Entry(Class<T> srvClass) {
            this.srvClass = srvClass;
            boolean bl = this.isAnnoted = srvClass.isInterface() && this.hasAnnotations(srvClass);
            if (this.isAnnoted) {
                log.info((Object)("handling  " + srvClass.getSimpleName() + " for " + AnnotatedServiceProvider.this.annotationClass().getSimpleName()));
            }
        }

        protected boolean hasAnnotations(Class<?> srvClass) {
            Class<? extends Annotation> annotationClass = AnnotatedServiceProvider.this.annotationClass();
            if (srvClass.isAnnotationPresent(annotationClass)) {
                return true;
            }
            for (Method m : srvClass.getMethods()) {
                if (m.getAnnotation(Transacted.class) == null) continue;
                return true;
            }
            return false;
        }

        public T getService() {
            T srvObject;
            T t = srvObject = AnnotatedServiceProvider.this.nextProvider != null ? AnnotatedServiceProvider.this.nextProvider.getService(this.srvClass) : Framework.getRuntime().getService(this.srvClass);
            if (!this.isAnnoted) {
                return srvObject;
            }
            return AnnotatedServiceProvider.this.newProxy(srvObject, this.srvClass);
        }
    }
}

