/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.transaction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class TransactionHelper {
    private static final Log log = LogFactory.getLog(TransactionHelper.class);
    public static final String[] UT_NAMES = new String[]{"java:comp/UserTransaction", "java:comp/env/UserTransaction", "UserTransaction"};
    public static final String[] TM_NAMES = new String[]{"java:comp/TransactionManager", "java:comp/env/TransactionManager", "java:TransactionManager"};
    private static ThreadLocal<List<Exception>> suppressedExceptions = new ThreadLocal();

    private TransactionHelper() {
    }

    public static UserTransaction lookupUserTransaction() throws NamingException {
        InitialContext context = new InitialContext();
        int i = 0;
        for (String name : UT_NAMES) {
            try {
                Object lookup = context.lookup(name);
                UserTransaction userTransaction = (UserTransaction)lookup;
                if (userTransaction != null) {
                    if (i != 0) {
                        TransactionHelper.UT_NAMES[i] = UT_NAMES[0];
                        TransactionHelper.UT_NAMES[0] = name;
                    }
                    return userTransaction;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            ++i;
        }
        throw new NamingException("UserTransaction not found in JNDI");
    }

    public static String getUserTransactionJNDIName() {
        return UT_NAMES[0];
    }

    public static TransactionManager lookupTransactionManager() throws NamingException {
        InitialContext context = new InitialContext();
        int i = 0;
        for (String name : TM_NAMES) {
            try {
                TransactionManager transactionManager = (TransactionManager)context.lookup(name);
                if (transactionManager != null) {
                    if (i != 0) {
                        TransactionHelper.TM_NAMES[i] = TM_NAMES[0];
                        TransactionHelper.TM_NAMES[0] = name;
                    }
                    return transactionManager;
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            ++i;
        }
        throw new NamingException("TransactionManager not found in JNDI");
    }

    public static boolean isTransactionActive() {
        try {
            return TransactionHelper.lookupUserTransaction().getStatus() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTransactionMarkedRollback() {
        try {
            return TransactionHelper.lookupUserTransaction().getStatus() == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isTransactionActiveOrMarkedRollback() {
        try {
            int status = TransactionHelper.lookupUserTransaction().getStatus();
            return status == 0 || status == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean startTransaction() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting transaction");
            }
            UserTransaction ut = TransactionHelper.lookupUserTransaction();
            ut.begin();
            return true;
        }
        catch (NamingException e) {
        }
        catch (Exception e) {
            log.error((Object)"Unable to start transaction", (Throwable)e);
        }
        return false;
    }

    public static Transaction requireNewTransaction() {
        TransactionManager tm;
        try {
            tm = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            return null;
        }
        try {
            Transaction tx = null;
            if (tm.getStatus() == 0) {
                tx = tm.suspend();
            }
            tm.begin();
            return tx;
        }
        catch (Exception e) {
            throw new TransactionRuntimeException("Cannot suspend tx", e);
        }
    }

    public static void resumeTransaction(Transaction tx) {
        TransactionManager mgr;
        try {
            mgr = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            return;
        }
        try {
            if (mgr.getStatus() == 0) {
                mgr.commit();
            }
            if (tx != null) {
                mgr.resume(tx);
            }
        }
        catch (Exception e) {
            throw new TransactionRuntimeException("Cannot resume tx", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startTransaction(int timeout) {
        TransactionManager txmgr;
        if (timeout < 0) {
            timeout = 0;
        }
        try {
            txmgr = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            return false;
        }
        try {
            txmgr.setTransactionTimeout(timeout);
        }
        catch (SystemException e) {
            log.error((Object)("Unable to set transaction timeout: " + timeout), (Throwable)e);
            return false;
        }
        try {
            boolean bl = TransactionHelper.startTransaction();
            return bl;
        }
        finally {
            try {
                txmgr.setTransactionTimeout(0);
            }
            catch (SystemException e) {
                log.error((Object)"Unable to reset transaction timeout", (Throwable)e);
            }
        }
    }

    public static void commitOrRollbackTransaction() {
        UserTransaction ut;
        try {
            ut = TransactionHelper.lookupUserTransaction();
        }
        catch (NamingException e) {
            log.warn((Object)"No user transaction", (Throwable)e);
            return;
        }
        try {
            int status = ut.getStatus();
            if (status == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Commiting transaction");
                }
                ut.commit();
            } else if (status == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot commit transaction because it is marked rollback only");
                }
                ut.rollback();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot commit transaction with unknown status: " + status));
            }
        }
        catch (Exception e) {
            String msg = "Unable to commit/rollback  " + ut;
            if (e instanceof RollbackException && "Unable to commit: transaction marked for rollback".equals(e.getMessage())) {
                log.debug((Object)msg, (Throwable)e);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            throw new TransactionRuntimeException(msg, e);
        }
    }

    public static void noteSuppressedExceptions() {
        suppressedExceptions.set(new ArrayList(1));
    }

    public static void noteSuppressedException(Exception e) {
        List<Exception> exceptions = suppressedExceptions.get();
        if (exceptions != null) {
            exceptions.add(e);
        }
    }

    public static List<Exception> getSuppressedExceptions() {
        List<Exception> exceptions = suppressedExceptions.get();
        suppressedExceptions.remove();
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    public static boolean setTransactionRollbackOnly() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting transaction as rollback only");
            }
            TransactionHelper.lookupUserTransaction().setRollbackOnly();
            return true;
        }
        catch (NamingException e) {
        }
        catch (Exception e) {
            log.error((Object)"Could not mark transaction as rollback only", (Throwable)e);
        }
        return false;
    }
}

