/*
 * Copyright (c) 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime;

/**
 * A runtime extension is a service that is started by the runtime when it starts using the runtime service context.
 * <p>
 * Runtime Extensions may be used to add new functionality to the runtime service.
 *
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 */
public interface RuntimeExtension {

    /**
     * Starts the runtime extension.
     * <p>
     * The current runtime is available as <code>Runtime.getRuntime()</code>.
     */
    void start();

    /**
     * Stops the runtime extension.
     * <p>
     * The current runtime is available as <code>Runtime.getRuntime()</code>.
     */
    void stop();

}
