/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.sessioninspector.jsf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.sessioninspector.jsf.model.MonitorNode;
import org.nuxeo.ecm.platform.sessioninspector.jsf.model.UIAliasHolderWrapper;
import org.nuxeo.ecm.platform.sessioninspector.jsf.model.UIComponentWrapper;
import org.nuxeo.ecm.platform.sessioninspector.util.ObjectVisitor;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="jsfStateManagerHandler")
public class StateManagerHandler
extends DefaultObject {
    private static final Log log = LogFactory.getLog(StateManagerHandler.class);
    private static final String STATE_ORDER_CLASS = "org.nuxeo.ecm.platform.ui.web.application.NuxeoConversationStateHolder";

    @GET
    @Produces(value={"text/html"})
    @Path(value="viewState/{viewId}/{sequenceId}")
    public Object viewState(@PathParam(value="viewId") String viewId, @PathParam(value="sequenceId") String sequenceId, @PathParam(value="computeSize") boolean computeSize) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        MonitorNode rootNode = this.getMonitorNode(viewId, sequenceId);
        long dSessionSize = -1L;
        long cumulatedSize = -1L;
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("viewId", viewId);
        args.put("sequenceId", sequenceId);
        args.put("dSessionSize", dSessionSize);
        args.put("cumulatedSize", rootNode.getCumulatedSize());
        args.put("cumulatedDepth", rootNode.getCumulatedDepth());
        args.put("maxDepth", rootNode.getMaxDepth());
        List<MonitorNode> nodeList = rootNode.toList();
        args.put("nodeList", nodeList);
        args.put("nbBranch", nodeList.size());
        return this.getView("viewState").args(args);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="viewObjects/{viewId}/{sequenceId}")
    public Object viewStats(@PathParam(value="viewId") String viewId, @PathParam(value="sequenceId") String sequenceId, @PathParam(value="computeSize") boolean computeSize) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ObjectVisitor v = new ObjectVisitor();
        v.visit(this.getState(viewId, sequenceId));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("viewId", viewId);
        args.put("sequenceId", sequenceId);
        args.put("objectList", v.getObjectStatisticsList());
        return this.getView("viewObjects").args(args);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="uiComponent/{viewId}/{sequenceId}/{path}")
    public Object viewUIComponent(@PathParam(value="viewId") String viewId, @PathParam(value="sequenceId") String sequenceId, @PathParam(value="path") String path) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        MonitorNode rootNode = this.getMonitorNode(viewId, sequenceId);
        MonitorNode childNode = rootNode.getChild(path.split(":"));
        UIComponentWrapper comp = new UIComponentWrapper(childNode.getId(), (Object[])childNode.getStateReference());
        Map<String, Object> args = this.getArguments(childNode, comp, path);
        return this.getView("uiComponent").args(args);
    }

    protected Map<String, Object> getArguments(MonitorNode node, UIComponentWrapper comp, String path) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("id", comp.getId());
        args.put("path", path);
        args.put("type", node.getType());
        args.put("children", comp.getFlatState());
        args.put("depth", node.getDepth());
        args.put("size", node.getSize());
        return args;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="uiAliasHolder/{viewId}/{sequenceId}/{path}")
    public Object viewUIAliasHolder(@PathParam(value="viewId") String viewId, @PathParam(value="sequenceId") String sequenceId, @PathParam(value="path") String path) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        MonitorNode rootNode = this.getMonitorNode(viewId, sequenceId);
        MonitorNode childNode = rootNode.getChild(path.split(":"));
        UIAliasHolderWrapper alias = new UIAliasHolderWrapper(childNode.getId(), (Object[])childNode.getStateReference());
        Map<String, Object> args = this.getArguments(childNode, alias, path);
        args.put("aliasId", alias.getAliasId());
        args.put("mapperSize", alias.getAliasVariableMapperSize());
        args.put("variables", alias.getVariables().entrySet());
        return this.getView("uiAliasHolder").args(args);
    }

    private MonitorNode getMonitorNode(String viewId, String sequenceId) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object[] o = this.getState(viewId, sequenceId);
        return new MonitorNode(o[0], (Object[])((Object[])o[1])[0]);
    }

    private Object[] getState(String viewId, String sequenceId) {
        return null;
    }
}

