/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.project.sample;

import java.io.Serializable;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class BookISBNEventListener
implements EventListener {
    public void handleEvent(Event event) {
        String type;
        DocumentEventContext docCtx;
        DocumentModel doc;
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext && (doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()) != null && "Book".equals(type = doc.getType())) {
            this.process(doc);
        }
    }

    public void process(DocumentModel doc) {
        String isbn = (String)((Object)doc.getPropertyValue("book:isbn"));
        String title = (String)((Object)doc.getPropertyValue("dublincore:title"));
        if (isbn == null || title == null || isbn.trim().equals("") || title.trim().equals("")) {
            return;
        }
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session dir = dirService.open("book_keywords");){
            DocumentModel entry = dir.getEntry(isbn);
            if (entry == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", isbn);
                map.put("label", title);
                dir.createEntry(map);
            } else {
                entry.setPropertyValue("vocabulary:label", (Serializable)((Object)title));
                dir.updateEntry(entry);
            }
        }
    }
}

