/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.styleguide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class StyleGuideURLCodec
extends AbstractDocumentViewCodec {
    public static final String DEFAULT_VIEW_ID = "style_guide";
    public static final String GET_URL_PATTERN = "/([a-zA-Z_0-9\\-\\.]*)?(/([a-zA-Z_0-9\\-]*))?(/([a-zA-Z_0-9\\-]*))?(/)?(\\?(.*)?)?";
    public static final String POST_URL_PATTERN = "/style_guide.faces(/)?(\\?(.*)?)?";

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            String viewId = docView.getViewId();
            if (viewId != null) {
                items.add(viewId);
            } else {
                items.add(DEFAULT_VIEW_ID);
            }
            Map docViewParams = docView.getParameters();
            HashMap params = new HashMap();
            if (docViewParams != null) {
                params.putAll(docViewParams);
                params.remove("conversationId");
                if (params.containsKey("tabId")) {
                    items.add((String)params.get("tabId"));
                    params.remove("tabId");
                    if (params.containsKey("subTabId")) {
                        items.add((String)params.get("subTabId"));
                        params.remove("subTabId");
                    }
                }
            }
            String uri = StringUtils.join(items, (String)"/");
            return URIUtils.addParametersToURIQuery((String)uri, params);
        }
        return null;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern;
        Matcher m;
        int jsessionidIndex = url.indexOf(";jsessionid");
        if (jsessionidIndex != -1) {
            url = url.substring(0, jsessionidIndex);
        }
        if ((m = (pattern = Pattern.compile(this.getPrefix() + POST_URL_PATTERN)).matcher(url)).matches() && m.groupCount() >= 1) {
            String query;
            Map params = null;
            if (m.groupCount() > 4 && (params = URIUtils.getRequestParameters((String)(query = m.group(5)))) != null) {
                params.remove("conversationId");
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(null, null);
            return new DocumentViewImpl((DocumentLocation)docLoc, null, params);
        }
        pattern = Pattern.compile(this.getPrefix() + GET_URL_PATTERN);
        m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 1) {
            String query;
            Map queryParams;
            String subTabId;
            String tabId;
            HashMap<String, String> params = new HashMap<String, String>();
            String menuId = m.group(1);
            if (menuId != null && !"".equals(menuId)) {
                params.put("menuId", menuId);
            }
            if ((tabId = m.group(3)) != null && !"".equals(tabId)) {
                params.put("tabId", tabId);
            }
            if ((subTabId = m.group(5)) != null && !"".equals(subTabId)) {
                params.put("subTabId", subTabId);
            }
            if (m.groupCount() > 3 && (queryParams = URIUtils.getRequestParameters((String)(query = m.group(8)))) != null) {
                queryParams.remove("conversationId");
                params.putAll(queryParams);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(null, null);
            return new DocumentViewImpl((DocumentLocation)docLoc, DEFAULT_VIEW_ID, params);
        }
        return null;
    }
}

