/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.styleguide.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.styleguide.service.StyleGuideIconRegistry;
import org.nuxeo.ecm.styleguide.service.StyleGuideService;
import org.nuxeo.ecm.styleguide.service.descriptors.IconDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class StyleGuideServiceImpl
extends DefaultComponent
implements StyleGuideService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StyleGuideServiceImpl.class);
    protected StyleGuideIconRegistry iconsReg;

    public void activate(ComponentContext context) {
        super.activate(context);
        this.iconsReg = new StyleGuideIconRegistry();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof IconDescriptor) {
            IconDescriptor icon = (IconDescriptor)contribution;
            log.info((Object)String.format("Register icon '%s'", icon.getPath()));
            this.registerIcon(icon);
            log.info((Object)String.format("Done registering icon '%s'", icon.getPath()));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof IconDescriptor) {
            IconDescriptor icon = (IconDescriptor)contribution;
            log.info((Object)String.format("Unregister icon '%s'", icon.getPath()));
            this.unregisterIcon(icon);
            log.info((Object)String.format("Done unregistering icon '%s'", icon.getPath()));
        }
    }

    protected void registerIcon(IconDescriptor icon) {
        this.iconsReg.addContribution(icon);
    }

    protected void unregisterIcon(IconDescriptor icon) {
        this.iconsReg.removeContribution(icon);
    }

    @Override
    public Map<String, List<IconDescriptor>> getIconsByCat(ExternalContext ctx, String path) {
        List<String> iconPaths = this.resolvePaths(ctx, path);
        HashMap<String, List<IconDescriptor>> res = new HashMap<String, List<IconDescriptor>>();
        ArrayList unknownCat = new ArrayList();
        res.put("unknown", unknownCat);
        if (iconPaths != null) {
            for (String iconPath : iconPaths) {
                List<String> cats;
                IconDescriptor desc = this.iconsReg.getIcon(iconPath);
                if (desc == null) {
                    desc = new IconDescriptor();
                    desc.setPath(iconPath);
                    desc.setLabel(FileUtils.getFileName((String)iconPath));
                    desc.setCategories(Arrays.asList("unknown"));
                }
                if (Boolean.FALSE.equals(desc.getEnabled()) || (cats = desc.getCategories()) == null) continue;
                for (String cat : cats) {
                    if (!res.containsKey(cat)) {
                        ArrayList newCat = new ArrayList();
                        res.put(cat, newCat);
                    }
                    ((List)res.get(cat)).add(desc);
                }
            }
        }
        return res;
    }

    protected List<String> resolvePaths(ExternalContext ctx, String basePath) {
        ArrayList<String> res = new ArrayList<String>();
        Set paths = ctx.getResourcePaths(basePath);
        if (paths != null) {
            for (String path : paths) {
                if (path.endsWith("/")) {
                    res.addAll(this.resolvePaths(ctx, path));
                    continue;
                }
                res.add(path);
            }
        }
        return res;
    }
}

