/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.api.descriptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.template.api.context.ContextExtensionFactory;

@XObject(value="contextFactory")
public class ContextExtensionFactoryDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(ContextExtensionFactoryDescriptor.class);
    @XNode(value="@name")
    protected String name;
    @XNode(value="@class")
    protected Class<? extends ContextExtensionFactory> factoryClass;
    @XNode(value="@enabled")
    protected boolean enabled = true;
    @XNodeList(value="aliasName", type=ArrayList.class, componentType=String.class)
    protected List<String> aliasNames = new ArrayList<String>();
    protected ContextExtensionFactory factory;

    public boolean isEnabled() {
        return this.enabled;
    }

    public ContextExtensionFactory getExtensionFactory() {
        if (this.factory == null && this.factoryClass != null) {
            try {
                this.factory = this.factoryClass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Unable to instanciate Processor", (Throwable)e);
            }
        }
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public ContextExtensionFactoryDescriptor clone() {
        ContextExtensionFactoryDescriptor copy = new ContextExtensionFactoryDescriptor();
        copy.name = this.name;
        copy.factoryClass = this.factoryClass;
        copy.enabled = this.enabled;
        copy.aliasNames = this.aliasNames;
        return copy;
    }

    public void merge(ContextExtensionFactoryDescriptor src) {
        if (src.factoryClass != null) {
            this.factoryClass = src.factoryClass;
        }
        if (src.aliasNames != null) {
            this.aliasNames.addAll(src.aliasNames);
        }
        this.enabled = src.enabled;
    }

    public List<String> getAliases() {
        return this.aliasNames;
    }
}

