/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.deckjs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.template.jaxrs.context.JAXRSExtensions;

@Operation(id="Blob.DeckJSToPDF", category="Conversion", label="Convert a deckJS slide to a pdf", description="Convert a deckJS slide to a pdf.")
public class DeckJSPDFOperation {
    public static final String ID = "Blob.DeckJSToPDF";
    @Context
    OperationContext ctx;
    @Context
    ConversionService conversionService;

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        DocumentModel templateSourceDocument = (DocumentModel)this.ctx.get((Object)"templateSourceDocument");
        DocumentModel templateBasedDocument = (DocumentModel)this.ctx.get((Object)"templateBasedDocument");
        String templateName = (String)this.ctx.get((Object)"templateName");
        String workingDirPath = System.getProperty("java.io.tmpdir") + "/nuxeo-deckJS-cache/" + templateBasedDocument.getId();
        File workingDir = new File(workingDirPath);
        if (!workingDir.exists()) {
            workingDir.mkdirs();
        }
        JAXRSExtensions jaxRsExtensions = new JAXRSExtensions(templateBasedDocument, null, templateName);
        BlobHolder sourceBh = (BlobHolder)templateSourceDocument.getAdapter(BlobHolder.class);
        for (Blob b : sourceBh.getBlobs()) {
            this.writeToTempDirectory(workingDir, b);
        }
        BlobHolder templatebasedBh = (BlobHolder)templateBasedDocument.getAdapter(BlobHolder.class);
        for (Blob b : templatebasedBh.getBlobs()) {
            this.writeToTempDirectory(workingDir, b);
        }
        String content = blob.getString();
        String resourcePath = jaxRsExtensions.getResourceUrl("");
        content = content.replaceAll(resourcePath, "./");
        File index = new File(workingDir, blob.getFilename());
        FileWriter fw = new FileWriter(index);
        IOUtils.write((String)content, (Writer)fw);
        fw.flush();
        fw.close();
        FileBlob indexBlob = new FileBlob(index);
        indexBlob.setFilename(blob.getFilename());
        BlobHolder bh = this.conversionService.convert("deckJSToPDF", (BlobHolder)new SimpleCachableBlobHolder((Blob)indexBlob), null);
        FileUtils.deleteDirectory((File)workingDir);
        return bh.getBlob();
    }

    private void writeToTempDirectory(File workingDir, Blob b) throws IOException {
        File f = new File(workingDir, b.getFilename());
        File parentFile = f.getParentFile();
        parentFile.mkdirs();
        b.transferTo(f);
    }
}

