/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.deckjs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.nuxeo.template.deckjs.Activator;

public class DeckJSPDFConverter
implements Converter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        SimpleCachableBlobHolder simpleCachableBlobHolder;
        File jsFile = null;
        try {
            StreamingBlob streamingBlob;
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability commandAvailability = cles.getCommandAvailability("phantomjs");
            if (!commandAvailability.isAvailable()) {
                BlobHolder blobHolder2 = null;
                return blobHolder2;
            }
            Blob blob = blobHolder.getBlob();
            File inputFile = null;
            if (blob instanceof FileBlob) {
                inputFile = ((FileBlob)blob).getFile();
            } else if (blob instanceof SQLBlob) {
                StreamSource source = ((SQLBlob)blob).getBinary().getStreamSource();
                inputFile = ((FileSource)source).getFile();
            } else if (blob instanceof StreamingBlob) {
                streamingBlob = (StreamingBlob)blob;
                if (!streamingBlob.isPersistent()) {
                    streamingBlob.persist();
                }
                StreamSource source = streamingBlob.getStreamSource();
                inputFile = ((FileSource)source).getFile();
            } else if (blob instanceof StringBlob) {
                inputFile = File.createTempFile("deckJsSource", ".html");
                Framework.trackFile((File)inputFile, (Object)this);
                org.nuxeo.common.utils.FileUtils.writeFile((File)inputFile, (String)blob.getString());
            }
            if (inputFile == null) {
                streamingBlob = null;
                return streamingBlob;
            }
            InputStream is = Activator.getResourceAsStream("phantomscript/deckJs2pdf.js");
            jsFile = File.createTempFile("phantomJsScript", ".js");
            FileWriter fw = new FileWriter(jsFile);
            IOUtils.copy((InputStream)is, (Writer)fw);
            fw.flush();
            fw.close();
            is.close();
            CmdParameters params = new CmdParameters();
            File outputFile = File.createTempFile("nuxeodeckjsPDFrendition", ".pdf");
            params.addNamedParameter("inFilePath", inputFile);
            params.addNamedParameter("outFilePath", outputFile);
            params.addNamedParameter("jsFilePath", jsFile);
            ExecResult res = cles.execCommand("phantomjs", params);
            if (!res.isSuccessful()) {
                throw res.getError();
            }
            FileBlob pdfOutput = new FileBlob(outputFile);
            pdfOutput.setMimeType("application/pdf");
            String filename = org.nuxeo.common.utils.FileUtils.getFileNameNoExt((String)blob.getFilename());
            filename = filename + ".pdf";
            pdfOutput.setFilename(filename);
            Framework.trackFile((File)outputFile, (Object)pdfOutput);
            simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)pdfOutput);
            FileUtils.deleteQuietly((File)jsFile);
        }
        catch (IOException | ClientException | CommandException | CommandNotAvailable e) {
            throw new ConversionException("PDF conversion failed", (Exception)e);
        }
        finally {
            FileUtils.deleteQuietly(jsFile);
        }
        return simpleCachableBlobHolder;
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

