/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.jod;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.DocumentTemplateFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.InputType;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.fm.FMContextBuilder;
import org.nuxeo.template.fm.FreeMarkerVariableExtractor;
import org.nuxeo.template.odt.OOoArchiveModifier;
import org.nuxeo.template.processors.AbstractTemplateProcessor;

public class JODReportTemplateProcessor
extends AbstractTemplateProcessor
implements TemplateProcessor {
    public static final String TEMPLATE_TYPE = "JODTemplate";
    protected FMContextBuilder fmContextBuilder = new FMContextBuilder();

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) throws Exception {
        ArrayList<TemplateInput> params = new ArrayList<TemplateInput>();
        String xmlContent = this.readXMLContent(blob);
        List vars = FreeMarkerVariableExtractor.extractVariables((String)xmlContent);
        for (String var : vars) {
            TemplateInput input = new TemplateInput(var);
            params.add(input);
        }
        return params;
    }

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws Exception {
        OOoArchiveModifier modifier = new OOoArchiveModifier();
        Blob sourceTemplateBlob = templateBasedDocument.getTemplateBlob(templateName);
        if (templateBasedDocument.getSourceTemplateDoc(templateName) != null) {
            sourceTemplateBlob = ((TemplateSourceDocument)templateBasedDocument.getSourceTemplateDoc(templateName).getAdapter(TemplateSourceDocument.class)).getTemplateBlob();
        }
        List params = templateBasedDocument.getParams(templateName);
        DocumentTemplateFactory documentTemplateFactory = new DocumentTemplateFactory();
        DocumentTemplate template = documentTemplateFactory.getTemplate(sourceTemplateBlob.getStream());
        HashMap<String, Object> context = new HashMap<String, Object>();
        ArrayList<Blob> blobsToInsert = new ArrayList<Blob>();
        DocumentObjectWrapper nuxeoWrapper = new DocumentObjectWrapper(null);
        for (TemplateInput param : params) {
            if (param.isSourceValue()) {
                Property property = null;
                try {
                    property = templateBasedDocument.getAdaptedDoc().getProperty(param.getSource());
                }
                catch (Throwable e) {
                    log.warn((Object)("Unable to ready property " + param.getSource()), e);
                }
                if (property == null) continue;
                Serializable value = property.getValue();
                if (value != null) {
                    if (Blob.class.isAssignableFrom(value.getClass())) {
                        Blob blob = (Blob)value;
                        if (param.getType() != InputType.PictureProperty) continue;
                        if (blob.getMimeType() == null || "".equals(blob.getMimeType().trim())) {
                            blob.setMimeType("image/jpeg");
                        }
                        context.put(param.getName(), blob);
                        blobsToInsert.add((Blob)value);
                        continue;
                    }
                    context.put(param.getName(), nuxeoWrapper.wrap((Object)property));
                    continue;
                }
                Type pType = property.getType();
                if (pType.getName().equals("boolean")) {
                    context.put(param.getName(), new Boolean(false));
                    continue;
                }
                if (pType.getName().equals("date")) {
                    context.put(param.getName(), new Date());
                    continue;
                }
                if (pType.getName().equals("string")) {
                    context.put(param.getName(), "");
                    continue;
                }
                if (pType.getName().equals("string")) {
                    context.put(param.getName(), "");
                    continue;
                }
                context.put(param.getName(), new Object());
                continue;
            }
            if (InputType.StringValue.equals((Object)param.getType())) {
                context.put(param.getName(), param.getStringValue());
                continue;
            }
            if (InputType.BooleanValue.equals((Object)param.getType())) {
                context.put(param.getName(), param.getBooleanValue());
                continue;
            }
            if (!InputType.DateValue.equals((Object)param.getType())) continue;
            context.put(param.getName(), param.getDateValue());
        }
        DocumentModel doc = templateBasedDocument.getAdaptedDoc();
        context.putAll(this.fmContextBuilder.build(doc, templateName));
        File workingDir = this.getWorkingDir();
        File generated = new File(workingDir, "JODReportresult");
        generated.createNewFile();
        template.createDocument(context, (OutputStream)new FileOutputStream(generated));
        generated = modifier.updateArchive(workingDir, generated, blobsToInsert);
        FileBlob newBlob = new FileBlob(generated);
        newBlob.setMimeType("application/vnd.oasis.opendocument.text");
        if (templateBasedDocument.getTemplateBlob(templateName) != null) {
            newBlob.setFilename(templateBasedDocument.getTemplateBlob(templateName).getFilename());
        } else {
            newBlob.setFilename(sourceTemplateBlob.getFilename());
        }
        Framework.trackFile((File)generated, (Object)newBlob);
        return newBlob;
    }

    public String readXMLContent(Blob blob) throws Exception {
        ZipInputStream zIn = new ZipInputStream(blob.getStream());
        ZipEntry zipEntry = zIn.getNextEntry();
        String xmlContent = null;
        while (zipEntry != null) {
            if (zipEntry.getName().equals("content.xml")) {
                int read;
                StringBuilder sb = new StringBuilder();
                byte[] buffer = new byte[65536];
                while ((read = zIn.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, read));
                }
                xmlContent = sb.toString();
                break;
            }
            zipEntry = zIn.getNextEntry();
        }
        zIn.close();
        return xmlContent;
    }
}

