/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.samples;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.PathFilter;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.samples.io.XMLModelReader;

public class ModelImporter {
    protected static final Log log = LogFactory.getLog(ModelImporter.class);
    private static final String TEMPLATE_SAMPLE_INIT_EVENT = "TemplateSampleInit";
    private static final String RESOURCES_ROOT = "templatesamples";
    public static final String EXAMPLES_ROOT = "examples";
    public static final String TEMPLATE_ROOT = "template";
    protected static final String DOMAIN_QUERY = "select * from Domain where ecm:isCheckedInVersion=0  AND  ecm:currentLifeCycleState != 'deleted' order by dc:created ASC";
    protected static final String SAMPLES_ROOT_PATH = "templateSamples";
    protected final CoreSession session;

    public ModelImporter(CoreSession session) {
        this.session = session;
    }

    protected DocumentModel getTargetDomain() throws ClientException {
        return this.getTargetDomain(true);
    }

    protected DocumentModel getTargetDomain(boolean canRetry) throws ClientException {
        DocumentModelList domains = this.session.query(DOMAIN_QUERY);
        if (domains.size() > 0) {
            return (DocumentModel)domains.get(0);
        }
        if (canRetry) {
            this.session.save();
            return this.getTargetDomain(false);
        }
        return null;
    }

    protected DocumentModel getOrCreateTemplateContainer() throws ClientException {
        DocumentModelList roots;
        DocumentModel rootDomain = this.getTargetDomain();
        if (rootDomain != null && (roots = this.session.getChildren(rootDomain.getRef(), "TemplateRoot")).size() > 0) {
            return (DocumentModel)roots.get(0);
        }
        return null;
    }

    protected DocumentModel getOrCreateSampleContainer() throws ClientException {
        DocumentModelList roots;
        DocumentModel rootDomain = this.getTargetDomain();
        DocumentModel container = null;
        if (rootDomain != null && (roots = this.session.getChildren(rootDomain.getRef(), "WorkspaceRoot")).size() > 0) {
            DocumentModel WSRoot = (DocumentModel)roots.get(0);
            PathRef targetPath = new PathRef(WSRoot.getPathAsString() + "/" + SAMPLES_ROOT_PATH);
            if (!this.session.exists((DocumentRef)targetPath)) {
                container = this.session.createDocumentModel(WSRoot.getPathAsString(), SAMPLES_ROOT_PATH, "Workspace");
                container.setPropertyValue("dc:title", (Serializable)((Object)"Template usage samples"));
                container.setPropertyValue("dc:description", (Serializable)((Object)"This workspace contains some sample usage of the template rendition system"));
                container = this.session.createDocument(container);
            } else {
                container = this.session.getDocument((DocumentRef)targetPath);
            }
        }
        return container;
    }

    protected boolean isImportAlreadyDone() {
        if (Framework.isTestModeSet()) {
            return false;
        }
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventId", TEMPLATE_SAMPLE_INIT_EVENT);
        List res = reader.nativeQuery("select count(log.id) from LogEntry log where log.eventId=:eventId", params, 1, 20);
        long resultsCount = (Long)res.get(0);
        return resultsCount != 0L;
    }

    protected void markImportDone() {
        if (Framework.isTestModeSet()) {
            return;
        }
        AuditLogger writer = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        LogEntry entry = writer.newLogEntry();
        entry.setEventId(TEMPLATE_SAMPLE_INIT_EVENT);
        entry.setEventDate(Calendar.getInstance().getTime());
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        writer.addLogEntries(entries);
    }

    protected static Path getDataDirPath() {
        String dataDir = null;
        dataDir = Framework.isTestModeSet() ? "/tmp" : Framework.getProperty((String)"nuxeo.data.dir");
        Path path = new Path(dataDir);
        path = path.append("resources");
        return path;
    }

    public static void expandResources() throws Exception {
        String jarPath = ModelImporter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        File jar = new File(jarPath);
        Path path = ModelImporter.getDataDirPath();
        File dataDir = new File(path.toString());
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        ZipUtils.unzip((File)jar, (File)dataDir, (PathFilter)new PathFilter(){

            public boolean isExclusive() {
                return true;
            }

            public boolean accept(Path path) {
                return path.toString().contains(ModelImporter.RESOURCES_ROOT);
            }
        });
    }

    public int importModels() throws Exception {
        File[] modelRoots;
        if (this.isImportAlreadyDone()) {
            return 0;
        }
        int nbImportedDocs = 0;
        File root = FileUtils.getResourceFileFromContext((String)RESOURCES_ROOT);
        if (root == null) {
            Path path = ModelImporter.getDataDirPath();
            path = path.append(RESOURCES_ROOT);
            root = new File(path.toString());
        }
        for (File modelRoot : modelRoots = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            log.info((Object)("Importing template from " + modelRoot.getAbsolutePath()));
            nbImportedDocs += this.importModelAndExamples(modelRoot);
        }
        this.markImportDone();
        return nbImportedDocs;
    }

    public int importModelAndExamples(File root) throws Exception {
        int nbImportedDocs = 0;
        final HashMap roots = new HashMap();
        root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                if (file.getName().equals(ModelImporter.TEMPLATE_ROOT)) {
                    roots.put(ModelImporter.TEMPLATE_ROOT, file);
                    return true;
                }
                if (file.getName().equals(ModelImporter.EXAMPLES_ROOT)) {
                    roots.put(ModelImporter.EXAMPLES_ROOT, file);
                    return true;
                }
                return false;
            }
        });
        if (roots.size() >= 1 && roots.get(TEMPLATE_ROOT) != null) {
            DocumentModel templatesContainer = this.getOrCreateTemplateContainer();
            DocumentModel samplesContainer = this.getOrCreateSampleContainer();
            if (templatesContainer != null) {
                DocumentRef modelRef = this.importModel(root.getName(), (File)roots.get(TEMPLATE_ROOT), templatesContainer);
                ++nbImportedDocs;
                if (samplesContainer != null && roots.get(EXAMPLES_ROOT) != null) {
                    nbImportedDocs += this.importSamples((File)roots.get(EXAMPLES_ROOT), modelRef, samplesContainer);
                }
            }
        }
        return nbImportedDocs;
    }

    protected DocumentRef importModel(String modelName, File source, DocumentModel root) throws Exception {
        XMLModelReader reader = new XMLModelReader(source, modelName);
        DocumentModelWriter writer = new DocumentModelWriter(this.session, root.getPathAsString());
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        DocumentTranslationMap map = pipe.run();
        DocumentRef ref = (DocumentRef)map.getDocRefMap().values().iterator().next();
        this.session.save();
        return ref;
    }

    protected int importSamples(File root, DocumentRef modelRef, DocumentModel rootDoc) throws Exception {
        int nbImportedDocs = 0;
        for (File exampleDir : root.listFiles()) {
            if (!exampleDir.isDirectory()) continue;
            XMLModelReader reader = new XMLModelReader(exampleDir, exampleDir.getName());
            DocumentModelWriter writer = new DocumentModelWriter(this.session, rootDoc.getPathAsString());
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            final String targetUUID = modelRef.toString();
            pipe.addTransformer(new DocumentTransformer(){

                public boolean transform(ExportedDocument xdoc) throws IOException {
                    xdoc.getDocument().accept(new Visitor(){

                        public void visit(Text node) {
                        }

                        public void visit(ProcessingInstruction node) {
                        }

                        public void visit(Namespace namespace) {
                        }

                        public void visit(Entity node) {
                        }

                        public void visit(Comment node) {
                        }

                        public void visit(CDATA node) {
                        }

                        public void visit(Attribute node) {
                        }

                        public void visit(Element node) {
                            if ("templateId".equalsIgnoreCase(node.getName()) && "templateEntry".equalsIgnoreCase(node.getParent().getName())) {
                                log.debug((Object)("Translating uuid to " + targetUUID));
                                node.setText(targetUUID);
                            }
                        }

                        public void visit(DocumentType documentType) {
                        }

                        public void visit(Document document) {
                        }
                    });
                    return true;
                }
            });
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            ++nbImportedDocs;
        }
        this.session.save();
        return nbImportedDocs;
    }
}

