/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.preprocessor;

import fr.opensagres.xdocreport.document.odt.preprocessor.ODTBufferedDocument;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.odt.textstyling.IODTStylesGenerator;
import fr.opensagres.xdocreport.document.odt.textstyling.ODTStylesGeneratorProvider;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODTStyleContentHandler
extends ODTBufferedDocumentContentHandler {
    private static final String STYLES_ELT = "styles";
    private static final String STYLE_ELT = "style";
    protected List<Integer> existingStyles = new ArrayList<Integer>();
    protected final IODTStylesGenerator styleGen = ODTStylesGeneratorProvider.getStyleGenerator();

    public ODTStyleContentHandler(String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        super(entryName, fieldsMetadata, formatter, sharedContext);
    }

    @Override
    protected boolean needToProcessAutomaticStyles() {
        return false;
    }

    @Override
    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String styleName;
        int level;
        if (STYLE_ELT.equals(localName) && (level = this.styleGen.getHeaderStyleNameLevel(styleName = attributes.getValue("style:name"))) > 0) {
            this.existingStyles.add(level);
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    @Override
    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (STYLES_ELT.equals(localName)) {
            for (int i = 1; i <= this.styleGen.getHeaderStylesCount(); ++i) {
                if (this.existingStyles.contains(i)) continue;
                this.generateHeaderStyle(i);
            }
        }
        super.doEndElement(uri, localName, name);
    }

    protected void generateHeaderStyle(int level) {
        BufferedElement region = this.getCurrentElement();
        region.append(this.styleGen.generateHeaderStyle(level));
    }

    @Override
    protected String getTableRowName() {
        return "table:table-row";
    }

    @Override
    protected String getTableCellName() {
        return "table:table-cell";
    }

    @Override
    protected ODTBufferedDocument createDocument() {
        return new ODTBufferedDocument();
    }
}

