/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.xdocreport;

import fr.opensagres.xdocreport.core.document.SyntaxKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.template.processors.AbstractBindingResolver;
import org.nuxeo.template.processors.xdocreport.BlobImageProvider;

public class XDocReportBindingResolver
extends AbstractBindingResolver {
    protected final FieldsMetadata metadata;

    public XDocReportBindingResolver(FieldsMetadata metadata) {
        this.metadata = metadata;
    }

    protected String handleHtmlField(String paramName, String htmlValue) {
        this.metadata.addFieldAsTextStyling(paramName, SyntaxKind.Html);
        String html = super.handleHtmlField(paramName, htmlValue);
        html = html.replace("&amp;", "");
        return html;
    }

    protected void handleBlobField(String paramName, Blob blobValue) {
        if ("text/html".equals(blobValue.getMimeType())) {
            this.metadata.addFieldAsTextStyling(paramName, SyntaxKind.Html);
        }
    }

    protected Object handlePictureField(String paramName, Blob blobValue) {
        if (blobValue == null) {
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("blank.png");
            try {
                byte[] bin = FileUtils.readBytes((InputStream)is);
                blobValue = new ByteArrayBlob(bin);
                blobValue.setFilename("blank.png");
                blobValue.setMimeType("image/png");
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to read fake Blob", (Throwable)e);
            }
        }
        BlobImageProvider imgBlob = new BlobImageProvider(blobValue);
        this.metadata.addFieldAsImage(paramName);
        return imgBlob;
    }

    protected Object handleLoop(String paramName, Object value) {
        this.metadata.addFieldAsList(paramName);
        try {
            return this.getWrapper().wrap(value);
        }
        catch (TemplateModelException e) {
            return null;
        }
    }
}

