/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.adapters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.template.adapters.doc.TemplateBasedDocumentAdapterImpl;
import org.nuxeo.template.adapters.source.TemplateSourceDocumentAdapterImpl;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateAdapterFactory
implements DocumentAdapterFactory {
    protected static final Log log = LogFactory.getLog(TemplateAdapterFactory.class);

    public Object getAdapter(DocumentModel doc, Class adapterClass) {
        if (adapterClass.getSimpleName().equals(TemplateBasedDocument.class.getSimpleName())) {
            if (doc.hasFacet("TemplateBased")) {
                try {
                    return new TemplateBasedDocumentAdapterImpl(doc);
                }
                catch (ClientException e) {
                    log.error((Object)"Unable to create TemplateBasedDocumentAdapterImpl", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (adapterClass.getSimpleName().equals(TemplateSourceDocument.class.getSimpleName())) {
            if (doc.hasFacet("Template")) {
                return new TemplateSourceDocumentAdapterImpl(doc);
            }
            return null;
        }
        return null;
    }
}

