/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.adapters.doc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.XMLSerializer;
import org.nuxeo.template.adapters.AbstractTemplateDocument;
import org.nuxeo.template.adapters.doc.TemplateBinding;
import org.nuxeo.template.adapters.doc.TemplateBindings;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.processors.convert.ConvertHelper;

public class TemplateBasedDocumentAdapterImpl
extends AbstractTemplateDocument
implements Serializable,
TemplateBasedDocument {
    private static final long serialVersionUID = 1L;
    public static final String TEMPLATEBASED_FACET = "TemplateBased";
    protected ConvertHelper convertHelper = new ConvertHelper();
    protected final TemplateBindings bindings;

    public TemplateBasedDocumentAdapterImpl(DocumentModel doc) throws ClientException {
        this.adaptedDoc = doc;
        this.bindings = new TemplateBindings(doc);
    }

    public DocumentModel setTemplate(DocumentModel template, boolean save) throws ClientException {
        TemplateSourceDocument source = (TemplateSourceDocument)template.getAdapter(TemplateSourceDocument.class);
        if (source == null) {
            throw new ClientException("Can not bind to an non template document");
        }
        String tid = source.getId();
        String templateName = source.getName();
        if (!this.bindings.containsTemplateId(tid)) {
            if (templateName == null) {
                templateName = "default";
            }
            TemplateBinding tb = new TemplateBinding();
            tb.setTemplateId(tid);
            tb.setName(templateName);
            this.bindings.add(tb);
            try {
                this.initializeFromTemplate(templateName, false);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            this.bindings.save(this.adaptedDoc);
            if (save) {
                this.doSave();
            }
        }
        return this.adaptedDoc;
    }

    public DocumentModel removeTemplateBinding(String templateName, boolean save) throws ClientException {
        if (this.bindings.containsTemplateName(templateName)) {
            this.bindings.removeByName(templateName);
            this.bindings.save(this.adaptedDoc);
            if (save) {
                this.doSave();
            }
        }
        return this.adaptedDoc;
    }

    public TemplateSourceDocument getSourceTemplate(String templateName) throws Exception {
        DocumentModel template = this.getSourceTemplateDoc(templateName);
        if (template != null) {
            return (TemplateSourceDocument)template.getAdapter(TemplateSourceDocument.class);
        }
        return null;
    }

    public DocumentRef getSourceTemplateDocRef(String templateName) throws Exception {
        TemplateBinding binding = null;
        binding = templateName == null ? this.bindings.get() : this.bindings.get(templateName);
        if (binding == null) {
            return null;
        }
        return new IdRef(binding.getTemplateId());
    }

    public DocumentModel getSourceTemplateDoc(String templateName) throws Exception {
        TemplateBinding binding = null;
        binding = templateName == null ? this.bindings.get() : this.bindings.get(templateName);
        if (binding == null) {
            return null;
        }
        DocumentRef tRef = this.getSourceTemplateDocRef(templateName);
        if (tRef == null) {
            return null;
        }
        return this.getSession().getDocument(tRef);
    }

    public List<TemplateSourceDocument> getSourceTemplates() {
        ArrayList<TemplateSourceDocument> result = new ArrayList<TemplateSourceDocument>();
        for (TemplateBinding binding : this.bindings) {
            try {
                result.add(this.getSourceTemplate(binding.getName()));
            }
            catch (Exception e) {
                log.error((Object)("Unable to fetch source template for binding " + binding.getName()));
            }
        }
        return result;
    }

    public String getTemplateType(String templateName) {
        TemplateSourceDocument source = null;
        try {
            source = this.getSourceTemplate(templateName);
        }
        catch (Exception e) {
            log.error((Object)("Unable to find source template for name " + templateName));
            return null;
        }
        if (source != null) {
            return source.getTemplateType();
        }
        return null;
    }

    public DocumentModel initializeFromTemplate(boolean save) throws Exception {
        return this.initializeFromTemplate("default", save);
    }

    public DocumentModel initializeFromTemplate(String templateName, boolean save) throws Exception {
        TemplateSourceDocument tmpl = this.getSourceTemplate(templateName);
        if (tmpl == null) {
            throw new ClientException("No associated template for name " + templateName);
        }
        List params = tmpl.getParams();
        ArrayList<TemplateInput> myParams = new ArrayList<TemplateInput>();
        for (TemplateInput param : params) {
            boolean readOnly = param.isSet() && !tmpl.allowInstanceOverride();
            TemplateInput myParam = param.getCopy(readOnly);
            myParams.add(myParam);
        }
        this.bindings.get(templateName).setData(myParams);
        if (tmpl.useAsMainContent()) {
            BlobHolder bh = (BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class);
            if (bh != null) {
                bh.setBlob(tmpl.getTemplateBlob());
            }
            this.bindings.get(templateName).setUseMainContentAsTemplate(true);
        }
        if (save) {
            this.doSave();
        }
        return this.adaptedDoc;
    }

    @Override
    protected void doSave() throws ClientException {
        this.bindings.save(this.adaptedDoc);
        super.doSave();
    }

    protected void setBlob(Blob blob) throws ClientException {
        ((BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class)).setBlob(blob);
    }

    protected Blob convertBlob(Blob blob, String format) throws Exception {
        return this.convertHelper.convertBlob(blob, format);
    }

    public Blob renderWithTemplate(String templateName) throws Exception {
        TemplateProcessor processor = this.getTemplateProcessor(templateName);
        if (processor != null) {
            Blob blob = processor.renderTemplate((TemplateBasedDocument)this, templateName);
            String format = this.getSourceTemplate(templateName).getOutputFormat();
            if (blob != null && format != null && !format.isEmpty()) {
                return this.convertBlob(blob, format);
            }
            return blob;
        }
        throw new ClientException("No template processor found for template type=" + this.getTemplateType(templateName));
    }

    public Blob renderAndStoreAsAttachment(String templateName, boolean save) throws Exception {
        Blob blob = this.renderWithTemplate(templateName);
        this.setBlob(blob);
        if (save) {
            this.adaptedDoc = this.getSession().saveDocument(this.adaptedDoc);
        }
        return blob;
    }

    public boolean isBidirectional() {
        return false;
    }

    public Blob getTemplateBlob(String templateName) throws Exception {
        TemplateSourceDocument source = this.getSourceTemplate(templateName);
        if (source != null) {
            Blob blob;
            BlobHolder bh;
            if (source.useAsMainContent() && (bh = (BlobHolder)this.getAdaptedDoc().getAdapter(BlobHolder.class)) != null && (blob = bh.getBlob()) != null) {
                return blob;
            }
            Blob blob2 = source.getTemplateBlob();
            return blob2;
        }
        BlobHolder bh = (BlobHolder)this.getAdaptedDoc().getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        return bh.getBlob();
    }

    public boolean hasParams(String templateName) throws ClientException {
        return this.getParams(templateName).size() > 0;
    }

    public List<TemplateInput> getParams(String templateName) throws ClientException {
        TemplateBinding binding = this.bindings.get(templateName);
        if (binding != null) {
            String xml = binding.getData();
            try {
                return XMLSerializer.readFromXml(xml);
            }
            catch (Exception e) {
                log.error((Object)"Unable to parse parameters", (Throwable)e);
                return new ArrayList<TemplateInput>();
            }
        }
        return new ArrayList<TemplateInput>();
    }

    public DocumentModel saveParams(String templateName, List<TemplateInput> params, boolean save) throws Exception {
        TemplateBinding binding = this.bindings.get(templateName);
        if (binding != null) {
            binding.setData(params);
            this.bindings.save(this.adaptedDoc);
        }
        if (save) {
            this.doSave();
        }
        return this.adaptedDoc;
    }

    protected TemplateProcessor getTemplateProcessor(String templateName) {
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
        return tps.getProcessor(this.getTemplateType(templateName));
    }

    public boolean hasEditableParams(String templateName) throws ClientException {
        for (TemplateInput param : this.getParams(templateName)) {
            if (param.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public String getTemplateNameForRendition(String renditionName) {
        try {
            for (TemplateBinding binding : this.bindings) {
                if (!renditionName.equals(this.getSourceTemplate(binding.getName()).getTargetRenditionName())) continue;
                return binding.getName();
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to resolve rendition binding", (Throwable)e);
        }
        return null;
    }

    public List<String> getTemplateNames() {
        return this.bindings.getNames();
    }
}

